/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.base;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.utils.JsonUtils;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.item.Item;

public final class CategoryDefinitionItem {
    final Item item;
    final EnumMap<FoodCategory, Float> foodValue;

    public CategoryDefinitionItem(Item item, EnumMap<FoodCategory, Float> foodValue) {
        this.item = item;
        this.foodValue = foodValue;
    }

    public Item getItem() {
        return this.item;
    }

    public EnumMap<FoodCategory, Float> getValues() {
        return this.foodValue;
    }

    public static final class Serializer
    implements JsonDeserializer<CategoryDefinitionItem>,
    JsonSerializer<CategoryDefinitionItem> {
        public CategoryDefinitionItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            Item item = JsonUtils.getItem(object, "item");
            EnumMap<FoodCategory, Float> foodValue = JsonUtils.getEnumMap(object, "values", FoodCategory.class, Float.class);
            return new CategoryDefinitionItem(item, foodValue);
        }

        public JsonElement serialize(CategoryDefinitionItem src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("item", Objects.requireNonNull(src.item.getRegistryName()).toString());
            JsonObject foodValueJsonObject = new JsonObject();
            src.foodValue.forEach((k, v) -> foodValueJsonObject.addProperty(k.name(), (Number)v));
            object.add("values", (JsonElement)foodValueJsonObject);
            return object;
        }
    }
}

