/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.tile.CrockPotTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CrockPotBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;

    public CrockPotBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 6.0f).func_200951_a(13).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CrockPotTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CrockPotTileEntity && state.func_177230_c() != newState.func_177230_c()) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stack = itemHandler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    CrockPotBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
                }
            });
            CrockPotTileEntity cast = (CrockPotTileEntity)tileEntity;
            if (cast.isProcessing()) {
                CrockPotBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)CrockPotRegistry.wetGoop.get()));
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && handIn == Hand.MAIN_HAND) {
            CrockPotTileEntity tileEntity = (CrockPotTileEntity)worldIn.func_175625_s(pos);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, packetBuffer -> {
                assert (tileEntity != null);
                packetBuffer.func_179255_a(tileEntity.func_174877_v());
            });
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, LIT});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.getLightValue(state, world, pos) : 0;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            double xPos = (double)pos.func_177958_n() + 0.5;
            double yPos = (double)pos.func_177956_o() + 0.2;
            double zPos = (double)pos.func_177952_p() + 0.5;
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a(xPos, yPos, zPos, SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.getPotLevel() == 2) {
                Direction direction = (Direction)stateIn.func_177229_b((IProperty)FACING);
                Direction.Axis directionAxis = direction.func_176740_k();
                double axisOffset = rand.nextDouble() * 0.3 - 0.15;
                double xOffset = directionAxis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.45 : axisOffset;
                double yOffset = rand.nextDouble() * 0.3 - 0.15;
                double zOffset = directionAxis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.45 : axisOffset;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197622_o, xPos + xOffset, yPos + yOffset, zPos + zOffset, 0.0, 0.0, 0.0);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197622_o, xPos - xOffset, yPos + yOffset, zPos - zOffset, 0.0, 0.0, 0.0);
            } else {
                double xOffset = rand.nextDouble() * 0.3 - 0.15;
                double zOffset = rand.nextDouble() * 0.3 - 0.15;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, xPos + xOffset, yPos, zPos + zOffset, 0.0, 0.0, 0.0);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, xPos + xOffset, yPos, zPos + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0.8f;
    }

    public abstract int getPotLevel();
}

