/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.block.CrockPotCropsBlock;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CrockPotDoubleCropsBlock
extends CrockPotCropsBlock {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), VoxelShapes.func_197868_b(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), VoxelShapes.func_197868_b()};

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    public boolean isTopBlock(BlockState state) {
        return this.func_185527_x(state) > this.func_185526_g() / 2;
    }

    public int getMaxGrowthAge(BlockState state) {
        return this.isTopBlock(state) ? this.func_185526_g() : this.func_185526_g() / 2;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (this.isTopBlock(state)) {
            BlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
            return stateDown.func_177230_c().getClass() == ((Object)((Object)this)).getClass() && this.func_185527_x(stateDown) == this.getMaxGrowthAge(stateDown);
        }
        return super.func_196260_a(state, worldIn, pos);
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        BlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        if (stateDown.func_177230_c().getClass() == ((Object)((Object)this)).getClass()) {
            worldIn.func_217377_a(pos.func_177977_b(), false);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        BlockPos blockPos;
        float growthChance;
        int age;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && (age = this.func_185527_x(state)) < this.func_185526_g() && rand.nextInt((int)(25.0f / (growthChance = CrockPotDoubleCropsBlock.func_180672_a((Block)this, (IBlockReader)worldIn, (BlockPos)(blockPos = this.isTopBlock(state) && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().getClass() == ((Object)((Object)this)).getClass() ? pos.func_177977_b() : pos)))) + 1) == 0) {
            if (age != this.getMaxGrowthAge(state)) {
                worldIn.func_175656_a(pos, this.func_185528_e(age + 1));
            } else if (worldIn.func_175623_d(pos.func_177984_a())) {
                worldIn.func_175656_a(pos.func_177984_a(), this.func_185528_e(age + 1));
            }
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        if (this.func_185527_x(state) < this.func_185526_g()) {
            if (this.func_185527_x(state) != this.getMaxGrowthAge(state)) {
                return true;
            }
            BlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
            return stateUp.func_177230_c().getClass() == ((Object)((Object)this)).getClass() && this.func_185527_x(stateUp) != this.getMaxGrowthAge(stateUp) || stateUp.isAir(worldIn, pos.func_177984_a());
        }
        return false;
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        int maxAge;
        int age = this.func_185527_x(state);
        if (age < (maxAge = this.func_185526_g())) {
            int maxGrowthAge = this.getMaxGrowthAge(state);
            if (age != maxGrowthAge) {
                int expectedAge = age + this.func_185529_b(worldIn);
                if (expectedAge > maxAge) {
                    expectedAge = maxAge;
                }
                if (expectedAge > maxGrowthAge) {
                    worldIn.func_175656_a(pos, this.func_185528_e(maxGrowthAge));
                    if (worldIn.func_175623_d(pos.func_177984_a())) {
                        worldIn.func_175656_a(pos.func_177984_a(), this.func_185528_e(expectedAge));
                    }
                } else {
                    worldIn.func_175656_a(pos, this.func_185528_e(expectedAge));
                }
            } else {
                BlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
                if (stateUp.func_177230_c().getClass() == ((Object)((Object)this)).getClass() && this.func_185527_x(stateUp) != this.getMaxGrowthAge(stateUp)) {
                    int expectedAge = this.func_185527_x(stateUp) + this.func_185529_b(worldIn);
                    if (expectedAge > maxAge) {
                        expectedAge = maxAge;
                    }
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_185528_e(expectedAge));
                } else if (worldIn.func_175623_d(pos.func_177984_a())) {
                    int expectedAge = age + this.func_185529_b(worldIn);
                    if (expectedAge > maxAge) {
                        expectedAge = maxAge;
                    }
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_185528_e(expectedAge));
                }
            }
        }
    }
}

