/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValueSum;
import com.sihenzhang.crockpot.recipe.Recipe;
import com.sihenzhang.crockpot.tile.CrockPotTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.Function;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.EnumUtils;

public class ModIntegrationTheOneProbe
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    public static final String MOD_ID = "theoneprobe";
    public static final String METHOD_NAME = "getTheOneProbe";

    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public String getID() {
        return "crockpot:crock_pot";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (tileEntity instanceof CrockPotTileEntity) {
            CrockPotTileEntity crockPotTileEntity = (CrockPotTileEntity)tileEntity;
            boolean needDrawInputs = false;
            ItemStackHandler itemHandler = crockPotTileEntity.getItemHandler();
            for (int i = 0; i < 4; ++i) {
                if (itemHandler.getStackInSlot(i).func_190926_b()) continue;
                needDrawInputs = true;
                break;
            }
            if (needDrawInputs) {
                ItemStack[] inputStacks = new ItemStack[4];
                for (int i = 0; i < 4; ++i) {
                    inputStacks[i] = itemHandler.getStackInSlot(i);
                }
                IProbeInfo inputs = probeInfo.horizontal(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-6710887)).spacing(0));
                Arrays.stream(inputStacks).forEach(arg_0 -> ((IProbeInfo)inputs).item(arg_0));
                if (player.func_225608_bj_()) {
                    IProbeInfo foodValues = probeInfo.vertical(probeInfo.defaultLayoutStyle().spacing(0));
                    ArrayList<EnumMap<FoodCategory, Float>> foodValueList = new ArrayList<EnumMap<FoodCategory, Float>>(4);
                    Arrays.stream(inputStacks).filter(stack -> !stack.func_190926_b()).forEach(stack -> foodValueList.add(CrockPot.FOOD_CATEGORY_MANAGER.valuesOf(stack.func_77973_b())));
                    FoodValueSum foodValueSum = new FoodValueSum(foodValueList);
                    IProbeInfo foodValuesHorizontal = null;
                    int categoryCount = 0;
                    for (FoodCategory category : EnumUtils.getEnumList(FoodCategory.class)) {
                        float foodValue = foodValueSum.getFoodValue(category);
                        if (foodValue == 0.0f) continue;
                        StringTextComponent suffix = new StringTextComponent("x" + foodValue);
                        if (categoryCount % 2 == 0) {
                            foodValuesHorizontal = foodValues.horizontal(probeInfo.defaultLayoutStyle().spacing(4));
                        }
                        foodValuesHorizontal.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(FoodCategory.getItemStack(category)).text((ITextComponent)suffix);
                        ++categoryCount;
                    }
                }
            }
            if (crockPotTileEntity.isProcessing()) {
                float progress;
                Recipe currentRecipe = crockPotTileEntity.getCurrentRecipe();
                if (!currentRecipe.isEmpty()) {
                    TranslationTextComponent prefix = new TranslationTextComponent("integration.crockpot.top.recipe", new Object[0]);
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((ITextComponent)prefix).item(currentRecipe.getResult()).text(currentRecipe.getResult().func_200301_q());
                }
                if ((progress = crockPotTileEntity.getProcessTimeProgress()) > 1.0E-6f) {
                    probeInfo.progress((int)(progress * 100.0f), 100, probeInfo.defaultProgressStyle().suffix("%"));
                }
            }
        }
    }
}

