/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.base.FoodCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import org.apache.commons.lang3.EnumUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class FoodCategoryProcessor
implements IComponentProcessor {
    private String categoryName;
    private float categoryValue;
    private Item[] items;

    public void setup(IVariableProvider<String> variables) {
        JsonObject categoryObj = JSONUtils.func_212745_a((String)((String)variables.get("category")));
        this.categoryName = categoryObj.get("name").getAsString();
        this.categoryValue = categoryObj.get("value").getAsFloat();
        FoodCategory category = (FoodCategory)EnumUtils.getEnum(FoodCategory.class, (String)this.categoryName.toUpperCase());
        this.items = CrockPot.FOOD_CATEGORY_MANAGER.getMatchingItems(category, this.categoryValue).toArray(new Item[0]);
    }

    public String process(String key) {
        if (key.startsWith("item")) {
            int index = Integer.parseInt(key.substring(4)) - 1;
            ItemStack stack = index < 0 || index >= this.items.length ? ItemStack.field_190927_a : new ItemStack((IItemProvider)this.items[index]);
            return PatchouliAPI.instance.serializeItemStack(stack);
        }
        if ("cname".equals(key)) {
            return I18n.func_135052_a((String)("item.crockpot.food_category_" + this.categoryName.toLowerCase()), (Object[])new Object[0]);
        }
        if ("cvalue".equals(key)) {
            return String.valueOf(this.categoryValue);
        }
        if ("title".equals(key)) {
            return I18n.func_135052_a((String)("item.crockpot.food_category_" + this.categoryName.toLowerCase()), (Object[])new Object[0]) + " x " + this.categoryValue;
        }
        return null;
    }
}

