/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item.food;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrockPotFood
extends Item {
    private final int useDuration;
    private final boolean drink;
    private final int cooldown;
    private final float heal;
    private final Pair<Supplier<DamageSource>, Float> damage;
    private final List<Supplier<Effect>> removedPotions;
    private final List<Supplier<ITextComponent>> tooltips;

    protected CrockPotFood(CrockPotFoodBuilder builder) {
        super(builder.properties.func_221540_a(builder.foodBuilder.func_221453_d()));
        this.useDuration = builder.useDuration;
        this.drink = builder.drink;
        this.cooldown = builder.cooldown;
        this.heal = builder.heal;
        this.damage = builder.damage;
        this.removedPotions = builder.removedPotions;
        this.tooltips = builder.tooltips;
    }

    public static CrockPotFoodBuilder builder() {
        return new CrockPotFoodBuilder();
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K) {
            if (this.damage != null && ((Float)this.damage.getValue()).floatValue() > 1.0E-6f) {
                entityLiving.func_70097_a((DamageSource)((Supplier)this.damage.getKey()).get(), ((Float)this.damage.getValue()).floatValue());
            }
            if (this.heal > 1.0E-6f) {
                entityLiving.func_70691_i(this.heal);
            }
            if (!this.removedPotions.isEmpty()) {
                this.removedPotions.forEach(potion -> entityLiving.func_195063_d((Effect)potion.get()));
            }
            if (this.cooldown > 0 && entityLiving instanceof PlayerEntity) {
                ((PlayerEntity)entityLiving).func_184811_cZ().func_185145_a((Item)this, this.cooldown);
            }
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public int func_77626_a(ItemStack stack) {
        return this.useDuration;
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.drink) {
            return UseAction.DRINK;
        }
        return super.func_77661_b(stack);
    }

    public SoundEvent func_225519_S__() {
        if (this.drink) {
            return SoundEvents.field_187664_bz;
        }
        return super.func_225519_S__();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.tooltips.isEmpty()) {
            this.tooltips.forEach(tip -> tooltip.add((ITextComponent)tip.get()));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static class CrockPotFoodBuilder {
        private Item.Properties properties = new Item.Properties().func_200916_a(CrockPot.ITEM_GROUP);
        private int maxStackSize = 64;
        private Rarity rarity = Rarity.COMMON;
        private Food.Builder foodBuilder = new Food.Builder();
        private int useDuration;
        private boolean drink;
        private int cooldown;
        private float heal;
        private Pair<Supplier<DamageSource>, Float> damage;
        private final List<Supplier<Effect>> removedPotions;
        private final List<Supplier<ITextComponent>> tooltips;

        public CrockPotFoodBuilder() {
            this.useDuration = FoodUseDuration.NORMAL.val;
            this.removedPotions = new ArrayList<Supplier<Effect>>();
            this.tooltips = new ArrayList<Supplier<ITextComponent>>();
        }

        public CrockPotFoodBuilder hunger(int hungerIn) {
            this.foodBuilder = this.foodBuilder.func_221456_a(hungerIn);
            return this;
        }

        public CrockPotFoodBuilder saturation(float saturationIn) {
            this.foodBuilder = this.foodBuilder.func_221454_a(saturationIn);
            return this;
        }

        public CrockPotFoodBuilder effect(EffectInstance effectIn, float probability) {
            this.foodBuilder = this.foodBuilder.effect(() -> effectIn, probability);
            return this;
        }

        public CrockPotFoodBuilder effect(Effect potionIn, int durationIn, int amplifierIn, float probability) {
            return this.effect(new EffectInstance(potionIn, durationIn, amplifierIn), probability);
        }

        public CrockPotFoodBuilder effect(EffectInstance effectIn) {
            return this.effect(effectIn, 1.0f);
        }

        public CrockPotFoodBuilder effect(Effect potionIn, int durationIn, int amplifierIn) {
            return this.effect(new EffectInstance(potionIn, durationIn, amplifierIn));
        }

        public CrockPotFoodBuilder effect(Effect potionIn, int durationIn) {
            return this.effect(new EffectInstance(potionIn, durationIn));
        }

        public CrockPotFoodBuilder meat() {
            this.foodBuilder = this.foodBuilder.func_221451_a();
            return this;
        }

        public CrockPotFoodBuilder setAlwaysEdible() {
            this.foodBuilder = this.foodBuilder.func_221455_b();
            return this;
        }

        public CrockPotFoodBuilder duration(FoodUseDuration durationIn) {
            this.useDuration = durationIn.val;
            return this;
        }

        public CrockPotFoodBuilder setDrink() {
            this.drink = true;
            return this;
        }

        public CrockPotFoodBuilder cooldown(int cooldownIn) {
            this.cooldown = cooldownIn;
            return this;
        }

        public CrockPotFoodBuilder heal(float healIn) {
            this.heal = healIn;
            return this;
        }

        public CrockPotFoodBuilder damage(DamageSource damageSourceIn, float damageAmountIn) {
            this.damage = Pair.of(() -> damageSourceIn, (Object)Float.valueOf(damageAmountIn));
            return this;
        }

        public CrockPotFoodBuilder removePotion(Effect potionIn) {
            this.removedPotions.add(() -> potionIn);
            return this;
        }

        public CrockPotFoodBuilder tooltip(String keyIn) {
            this.tooltips.add(() -> new TranslationTextComponent("tooltip.crockpot." + keyIn, new Object[0]));
            return this;
        }

        public CrockPotFoodBuilder tooltip(String keyIn, TextFormatting ... formatsIn) {
            this.tooltips.add(() -> new TranslationTextComponent("tooltip.crockpot." + keyIn, new Object[0]).func_211709_a(formatsIn));
            return this;
        }

        public CrockPotFoodBuilder setHidden() {
            this.properties = new Item.Properties();
            if (this.maxStackSize != 64) {
                this.properties = this.properties.func_200917_a(this.maxStackSize);
            }
            if (this.rarity != Rarity.COMMON) {
                this.properties = this.properties.func_208103_a(this.rarity);
            }
            return this;
        }

        public CrockPotFoodBuilder maxStackSize(int maxStackSizeIn) {
            this.maxStackSize = maxStackSizeIn;
            this.properties = this.properties.func_200917_a(this.maxStackSize);
            return this;
        }

        public CrockPotFoodBuilder rarity(Rarity rarityIn) {
            this.rarity = rarityIn;
            this.properties = this.properties.func_208103_a(this.rarity);
            return this;
        }

        public CrockPotFood build() {
            return new CrockPotFood(this);
        }
    }
}

