/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.recipe.Recipe;
import com.sihenzhang.crockpot.recipe.RecipeInput;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public final class RecipeManager
extends JsonReloadListener {
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(Recipe.class, (Object)new Recipe.Serializer()).create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();
    private List<Recipe> recipes = ImmutableList.of();
    private static ExecutorService EXECUTOR;

    public static void initExecutor() {
        EXECUTOR = (Boolean)CrockPotConfig.ASYNC_RECIPE_MATCHING.get() != false ? Executors.newFixedThreadPool((Integer)CrockPotConfig.ASYNC_RECIPE_MATCHING_POOL_SIZE.get(), new ThreadFactoryBuilder().setNameFormat("CrockPotMatchingWorker-%d").setDaemon(true).build()) : MoreExecutors.newDirectExecutorService();
    }

    public RecipeManager() {
        super(GSON_INSTANCE, "crock_pot");
    }

    public CompletableFuture<Recipe> match(RecipeInput input) {
        return CompletableFuture.supplyAsync(() -> this.matchBlocking(input), EXECUTOR);
    }

    private Recipe matchBlocking(RecipeInput input) {
        Iterator<Recipe> itr = this.recipes.iterator();
        LinkedList<Recipe> matched = new LinkedList<Recipe>();
        boolean isFirst = true;
        int p = 0;
        while (itr.hasNext()) {
            Recipe r = itr.next();
            if (isFirst) {
                if (!r.test(input)) continue;
                p = r.priority;
                matched.add(r);
                isFirst = false;
                continue;
            }
            if (r.priority != p) break;
            if (!r.test(input)) continue;
            matched.add(r);
        }
        if (matched.isEmpty()) {
            return Recipe.EMPTY;
        }
        int sum = 0;
        for (Recipe e : matched) {
            sum += e.weight;
        }
        int rand = RANDOM.nextInt(sum) + 1;
        for (Recipe e : matched) {
            if ((rand -= e.weight) > 0) continue;
            return e;
        }
        return Recipe.EMPTY;
    }

    protected void apply(Map<ResourceLocation, JsonObject> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        LinkedList<Recipe> recipes = new LinkedList<Recipe>();
        for (Map.Entry<ResourceLocation, JsonObject> entry : objectIn.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            if (resourceLocation.func_110623_a().startsWith("_")) continue;
            try {
                Recipe recipe = (Recipe)GSON_INSTANCE.fromJson((JsonElement)entry.getValue(), Recipe.class);
                recipes.add(recipe);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error("Parsing error loading crock pot recipe {}", (Object)resourceLocation, (Object)exception);
            }
        }
        recipes.sort(Comparator.comparingInt(r -> r.priority).reversed());
        this.recipes = ImmutableList.copyOf(recipes);
        LOGGER.info("Loaded {} crock pot recipes", (Object)recipes.size());
    }
}

