/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.requirements;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.recipe.RecipeInput;
import com.sihenzhang.crockpot.recipe.requirements.Requirement;
import com.sihenzhang.crockpot.recipe.requirements.RequirementType;
import net.minecraft.nbt.CompoundNBT;
import org.apache.commons.lang3.EnumUtils;

public class RequirementCategoryMax
extends Requirement {
    FoodCategory category;
    float max;

    public RequirementCategoryMax(FoodCategory category, float max) {
        this.category = category;
        this.max = max;
    }

    public RequirementCategoryMax(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public boolean test(RecipeInput recipeInput) {
        return recipeInput.foodValueSum.getFoodValue(this.category) <= this.max;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", RequirementType.CATEGORY_MAX.name().toLowerCase());
        nbt.func_74778_a("category", this.category.name());
        nbt.func_74776_a("max", this.max);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (!RequirementType.CATEGORY_MAX.name().equals(nbt.func_74779_i("type").toUpperCase())) {
            throw new IllegalArgumentException("Requirement type doesn't match");
        }
        this.category = (FoodCategory)EnumUtils.getEnum(FoodCategory.class, (String)nbt.func_74779_i("category").toUpperCase());
        this.max = nbt.func_74760_g("max");
    }
}

