/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.requirements;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.recipe.RecipeInput;
import com.sihenzhang.crockpot.recipe.requirements.Requirement;
import com.sihenzhang.crockpot.recipe.requirements.RequirementType;
import net.minecraft.nbt.CompoundNBT;
import org.apache.commons.lang3.EnumUtils;

public class RequirementCategoryMin
extends Requirement {
    FoodCategory category;
    float min;

    public RequirementCategoryMin(FoodCategory category, float min) {
        this.category = category;
        this.min = min;
    }

    public RequirementCategoryMin(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public boolean test(RecipeInput recipeInput) {
        return recipeInput.foodValueSum.getFoodValue(this.category) >= this.min;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", RequirementType.CATEGORY_MIN.name().toLowerCase());
        nbt.func_74778_a("category", this.category.name());
        nbt.func_74776_a("min", this.min);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (!RequirementType.CATEGORY_MIN.name().equals(nbt.func_74779_i("type").toUpperCase())) {
            throw new IllegalArgumentException("Requirement type doesn't match");
        }
        this.category = (FoodCategory)EnumUtils.getEnum(FoodCategory.class, (String)nbt.func_74779_i("category").toUpperCase());
        this.min = nbt.func_74760_g("min");
    }
}

