/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.requirements;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sihenzhang.crockpot.recipe.RecipeInput;
import com.sihenzhang.crockpot.recipe.requirements.Requirement;
import com.sihenzhang.crockpot.recipe.requirements.RequirementType;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;

public class RequirementMustContainIngredient
extends Requirement {
    Ingredient ingredient;
    int quantity;

    public RequirementMustContainIngredient(Ingredient ingredient, int quantity) {
        this.ingredient = ingredient;
        this.quantity = quantity;
    }

    public RequirementMustContainIngredient(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public boolean test(RecipeInput recipeInput) {
        return recipeInput.stacks.stream().filter(stack -> this.ingredient.test(stack)).count() >= (long)this.quantity;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", RequirementType.MUST_CONTAIN_INGREDIENT.name().toLowerCase());
        try {
            nbt.func_218657_a("ingredient", (INBT)JsonToNBT.func_180713_a((String)this.ingredient.func_200304_c().toString()));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        nbt.func_74768_a("quantity", this.quantity);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (!RequirementType.MUST_CONTAIN_INGREDIENT.name().equals(nbt.func_74779_i("type").toUpperCase())) {
            throw new IllegalArgumentException("Requirement type doesn't match");
        }
        JsonReader reader = new JsonReader((Reader)new StringReader(Objects.requireNonNull(nbt.func_74781_a("ingredient")).toString()));
        reader.setLenient(true);
        this.ingredient = Ingredient.func_199802_a((JsonElement)new JsonParser().parse(reader));
        this.quantity = nbt.func_74762_e("quantity");
    }
}

