/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.tile;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.recipe.RecipeInput;
import com.sihenzhang.crockpot.tile.CrockPotContext;
import com.sihenzhang.crockpot.tile.CrockPotTileEntity;
import java.util.Objects;
import java.util.function.BiConsumer;

public enum CrockPotState {
    IDLE(CrockPotState::processIdle),
    WAITING_MATCHING(CrockPotState::processWaitingMatching),
    PROCESSING(CrockPotState::processProcessing);

    private final BiConsumer<CrockPotTileEntity, CrockPotContext> process;

    private CrockPotState(BiConsumer<CrockPotTileEntity, CrockPotContext> process) {
        this.process = process;
    }

    static CrockPotState doPotTick(CrockPotState state, CrockPotTileEntity tile) {
        CrockPotContext ctx = new CrockPotContext();
        if (tile.burnTime <= 1 && state == PROCESSING) {
            tile.consumeFuel();
            tile.updateBurningState();
            tile.sync();
        }
        if (tile.burnTime > 0) {
            --tile.burnTime;
            ctx.isBurning = true;
            if (tile.burnTime == 0) {
                tile.updateBurningState();
            }
        }
        CrockPotState lastState = ctx.nextState;
        state.process.accept(tile, ctx);
        while (ctx.shouldContinueTick) {
            if (ctx.nextState == null) {
                throw new IllegalStateException("Next state should not be null, last state is " + lastState.name());
            }
            lastState = tile.currentState = ctx.nextState;
            ctx.nextState.process.accept(tile, ctx);
        }
        return ctx.nextState;
    }

    private static void processIdle(CrockPotTileEntity tile, CrockPotContext ctx) {
        if (!tile.itemHandler.getStackInSlot(5).func_190926_b()) {
            ctx.endTick(IDLE);
            return;
        }
        if (!ctx.isBurning && tile.itemHandler.getStackInSlot(4).func_190926_b()) {
            ctx.endTick(IDLE);
            return;
        }
        if (tile.shouldDoMatch) {
            tile.shouldDoMatch = false;
            RecipeInput input = tile.getRecipeInput();
            if (input != null) {
                if (!Objects.requireNonNull(tile.func_145831_w()).field_72995_K) {
                    tile.pendingRecipe = CrockPot.RECIPE_MANAGER.match(input);
                }
                ctx.continueNext(WAITING_MATCHING);
                return;
            }
        }
        ctx.endTick(IDLE);
    }

    private static void processWaitingMatching(CrockPotTileEntity tile, CrockPotContext ctx) {
        if (tile.pendingRecipe == null) {
            if (Objects.requireNonNull(tile.func_145831_w()).field_72995_K) {
                tile.shouldDoMatch = false;
                ctx.endTick(WAITING_MATCHING);
                return;
            }
            if (ctx.isBurning) {
                ++tile.burnTime;
            }
            tile.shouldDoMatch = true;
            ctx.endTick(IDLE);
            return;
        }
        if (tile.shouldDoMatch) {
            tile.pendingRecipe.cancel(true);
            ctx.endTick(IDLE);
            return;
        }
        if (tile.pendingRecipe.isDone()) {
            tile.currentRecipe = tile.pendingRecipe.join();
            if (tile.currentRecipe.isEmpty()) {
                ctx.endTick(IDLE);
            } else {
                tile.shrinkInputs();
                ctx.continueNext(PROCESSING);
                ctx.needSync = true;
            }
            tile.func_70296_d();
        } else {
            if (ctx.isBurning) {
                ++tile.burnTime;
            }
            System.out.println("waiting for recipe match");
            ctx.endTick(WAITING_MATCHING);
        }
    }

    private static void processProcessing(CrockPotTileEntity tile, CrockPotContext ctx) {
        if (ctx.needSync) {
            tile.sync();
        }
        ++tile.processTime;
        tile.func_70296_d();
        if (tile.processTime >= tile.currentRecipe.getCookTime()) {
            tile.itemHandler.setStackInSlot(5, tile.currentRecipe.getResult().func_77946_l());
            tile.processTime = 0;
            ctx.endTick(IDLE);
        } else {
            ctx.endTick(PROCESSING);
        }
    }
}

