/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.tile;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.base.FoodValueSum;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.container.CrockPotContainer;
import com.sihenzhang.crockpot.recipe.Recipe;
import com.sihenzhang.crockpot.recipe.RecipeInput;
import com.sihenzhang.crockpot.tile.CrockPotState;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrockPotTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    final ItemStackHandler itemHandler = new ItemStackHandler(6){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot < 4 ? !CrockPotTileEntity.isValidIngredient(stack) : slot == 4 && !CrockPotTileEntity.isItemFuel(stack)) {
                return stack;
            }
            CrockPotTileEntity.this.shouldDoMatch = !simulate;
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (!result.func_190926_b()) {
                CrockPotTileEntity.this.shouldDoMatch = !simulate;
            }
            return result;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            CrockPotTileEntity.this.shouldDoMatch = true;
            super.setStackInSlot(slot, stack);
        }
    };
    private final RangedWrapper itemHandlerInput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 4);
    private final RangedWrapper itemHandlerFuel = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 4, 5);
    private final RangedWrapper itemHandlerOutput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 5, 6);
    private final LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IItemHandler> itemHandlerInputCap = LazyOptional.of(() -> this.itemHandlerInput);
    private final LazyOptional<IItemHandler> itemHandlerFuelCap = LazyOptional.of(() -> this.itemHandlerFuel);
    private final LazyOptional<IItemHandler> itemHandlerOutputCap = LazyOptional.of(() -> this.itemHandlerOutput);
    int burnTime;
    int currentItemBurnTime;
    int processTime;
    boolean shouldDoMatch = true;
    Recipe currentRecipe = Recipe.EMPTY;
    CompletableFuture<Recipe> pendingRecipe;
    CrockPotState currentState = CrockPotState.IDLE;

    public CrockPotTileEntity() {
        super((TileEntityType)CrockPotRegistry.crockPotTileEntity.get());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.crockpot.crock_pot", new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new CrockPotContainer(i, playerInventory, this);
    }

    public void func_73660_a() {
        this.currentState = CrockPotState.doPotTick(this.currentState, this);
    }

    int getPotLevel() {
        assert (this.field_145850_b != null);
        return ((CrockPotBlock)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).getPotLevel();
    }

    public Recipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Nullable
    RecipeInput getRecipeInput() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(4);
        for (int i = 0; i < 4; ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) {
                return null;
            }
            ItemStack stack = this.itemHandler.getStackInSlot(i).func_77946_l();
            stack.func_190920_e(1);
            stacks.add(stack);
        }
        FoodValueSum sum = new FoodValueSum(stacks.stream().map(ItemStack::func_77973_b).map(CrockPot.FOOD_CATEGORY_MANAGER::valuesOf).collect(Collectors.toList()));
        return new RecipeInput(sum, stacks, this.getPotLevel());
    }

    void consumeFuel() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(4);
        if (!fuelStack.func_190926_b()) {
            ItemStack copy = fuelStack.func_77946_l();
            copy.func_190920_e(1);
            this.currentItemBurnTime = ForgeHooks.getBurnTime((ItemStack)copy);
            if (this.currentItemBurnTime > 0) {
                fuelStack.func_190918_g(1);
                this.burnTime += this.currentItemBurnTime;
            }
            if (copy.func_77973_b().getContainerItem(copy) != null && this.itemHandler.getStackInSlot(4).func_190926_b()) {
                this.itemHandler.setStackInSlot(4, copy.getContainerItem());
            }
        }
    }

    void updateBurningState() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)CrockPotBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
        }
    }

    void shrinkInputs() {
        for (int i = 0; i < 4; ++i) {
            this.itemHandler.getStackInSlot(i).func_190918_g(1);
        }
    }

    void sync() {
        assert (this.field_145850_b != null);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        SUpdateTileEntityPacket pkt = this.func_189518_D_();
        assert (pkt != null);
        ((ServerWorld)this.field_145850_b).func_72863_F().field_217237_a.func_219097_a(new ChunkPos(this.field_174879_c), false).forEach(p -> p.field_71135_a.func_147359_a((IPacket)pkt));
        this.func_70296_d();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack) > 0;
    }

    public static boolean isValidIngredient(ItemStack itemStack) {
        return !CrockPot.FOOD_CATEGORY_MANAGER.valuesOf(itemStack.func_77973_b()).isEmpty();
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.itemHandler.deserializeNBT(compound.func_74775_l("ItemHandler"));
        this.burnTime = compound.func_74765_d("BurnTime");
        this.currentItemBurnTime = compound.func_74765_d("CurrentItemBurnTime");
        this.processTime = compound.func_74765_d("ProcessTime");
        this.currentState = CrockPotState.valueOf(compound.func_74779_i("CurrentState"));
        if (compound.func_74764_b("CurrentRecipe")) {
            this.currentRecipe = new Recipe((CompoundNBT)Objects.requireNonNull(compound.func_74781_a("CurrentRecipe")));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        compound.func_74777_a("BurnTime", (short)this.burnTime);
        compound.func_74777_a("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        compound.func_74777_a("ProcessTime", (short)this.processTime);
        compound.func_74778_a("CurrentState", this.currentState.name());
        if (this.currentRecipe != null) {
            compound.func_218657_a("CurrentRecipe", (INBT)this.currentRecipe.serializeNBT());
        }
        return compound;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public float getBurnTimeProgress() {
        return (float)this.burnTime / (float)this.currentItemBurnTime;
    }

    public boolean isProcessing() {
        return this.currentState == CrockPotState.PROCESSING;
    }

    public float getProcessTimeProgress() {
        if (this.currentRecipe == null) {
            return 0.0f;
        }
        return (float)this.processTime / (float)this.currentRecipe.getCookTime();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.itemHandlerCap.cast();
            }
            switch (side) {
                case UP: {
                    return this.itemHandlerInputCap.cast();
                }
                case DOWN: {
                    return this.itemHandlerOutputCap.cast();
                }
            }
            return this.itemHandlerFuelCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

