/*
 * Decompiled with CFR 0.152.
 */
package com.cursery.enchant;

import com.cursery.Cursery;
import com.cursery.enchant.PlayerVisualHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;

public class CurseEnchantmentHelper {
    public static boolean delayNext = false;
    public static Item delayItem;
    private static Random rand;
    public static Map<Enchantment, Integer> curseWeightMap;
    public static int totalCurseWeight;
    public static ItemStack notifyStack;
    public static ServerPlayer notifyPlayer;

    public static boolean checkForRandomCurse(ItemStack stack, Map<Enchantment, Integer> previous, Map<Enchantment, Integer> newEnchants) {
        if (delayNext) {
            delayNext = false;
            if (stack.m_41720_() == delayItem) {
                return false;
            }
            delayItem = null;
        }
        if (stack == null || stack.m_41619_() || previous == null || newEnchants == null) {
            return false;
        }
        if (stack.m_41720_() == Items.f_42517_ || stack.m_41720_() == Items.f_42690_) {
            return false;
        }
        int levelSum = 0;
        for (Map.Entry<Enchantment, Integer> newEnchant : newEnchants.entrySet()) {
            if (newEnchant.getKey().m_6589_() || ((Boolean)Cursery.config.getCommonConfig().excludeTreasure.get()).booleanValue() && newEnchant.getKey().m_6591_()) continue;
            levelSum += newEnchant.getValue().intValue();
        }
        ArrayList<Integer> addedLevels = new ArrayList<Integer>();
        boolean appliedCurse = false;
        for (Map.Entry<Enchantment, Integer> newEnchant : newEnchants.entrySet()) {
            int newLevel = previous.containsKey(newEnchant.getKey()) ? newEnchant.getValue() - previous.get(newEnchant.getKey()) : newEnchant.getValue();
            if (newLevel <= 0 || ((Boolean)Cursery.config.getCommonConfig().excludeTreasure.get()).booleanValue() && newEnchant.getKey().m_6591_() || newEnchant.getKey().m_6589_()) continue;
            addedLevels.add(newLevel);
        }
        for (Integer newLevel : addedLevels) {
            if (!CurseEnchantmentHelper.rollAndApplyCurseTo(stack, newLevel, levelSum - newLevel, newEnchants)) continue;
            appliedCurse = true;
        }
        if (appliedCurse) {
            if (stack == notifyStack && notifyPlayer != null) {
                PlayerVisualHelper.randomNotificationOnCurseApply(notifyPlayer, notifyStack);
                notifyPlayer = null;
                notifyStack = null;
            }
        } else if (stack == notifyStack && notifyPlayer != null) {
            PlayerVisualHelper.enchantSuccess(notifyPlayer, notifyStack);
        }
        return appliedCurse;
    }

    private static boolean rollAndApplyCurseTo(ItemStack stack, int newLevel, int levelSum, Map<Enchantment, Integer> newEnchants) {
        boolean appliedCurse = false;
        block0: for (int i = 0; i < newLevel; ++i) {
            if (((Boolean)Cursery.config.getCommonConfig().debugTries.get()).booleanValue()) {
                Cursery.LOGGER.info("Rolling new curse for " + stack + " addedEnchLevels: " + newLevel + " totalEnchantLevels: " + levelSum + " chance:" + Math.min(75, (Integer)Cursery.config.getCommonConfig().basecursechance.get() + levelSum - (stack.getItemEnchantability() >> 1)));
            }
            if (rand.nextInt(100) >= Math.min(75, (Integer)Cursery.config.getCommonConfig().basecursechance.get() + levelSum - (stack.getItemEnchantability() >> 1))) continue;
            if (((Boolean)Cursery.config.getCommonConfig().debugTries.get()).booleanValue()) {
                Cursery.LOGGER.info("Trying to apply curse to: " + stack);
            }
            for (int j = 0; j < 15; ++j) {
                int currentLevel;
                Enchantment curse = CurseEnchantmentHelper.getRandomCurse();
                if (curse == null || (currentLevel = newEnchants.getOrDefault(curse, 0).intValue()) >= curse.m_6586_() || !curse.m_6081_(stack) || !CurseEnchantmentHelper.isCompatibleWithAll(curse, newEnchants)) continue;
                if (((Boolean)Cursery.config.getCommonConfig().debugTries.get()).booleanValue()) {
                    Cursery.LOGGER.info("Applying curse " + curse.getRegistryName() + " to: " + stack);
                }
                CurseEnchantmentHelper.enchantManually(stack, curse, currentLevel + 1);
                newEnchants.put(curse, currentLevel + 1);
                appliedCurse = true;
                continue block0;
            }
        }
        return appliedCurse;
    }

    private static boolean isCompatibleWithAll(Enchantment enchantment, Map<Enchantment, Integer> newEnchants) {
        for (Map.Entry<Enchantment, Integer> entry : newEnchants.entrySet()) {
            if (entry.getKey().m_44695_(enchantment)) continue;
            if (((Boolean)Cursery.config.getCommonConfig().debugTries.get()).booleanValue()) {
                Cursery.LOGGER.info("Curse " + enchantment.getRegistryName() + " is not compatible with " + entry.getKey().getRegistryName());
            }
            return false;
        }
        return true;
    }

    private static Enchantment getRandomCurse() {
        int chosen = Cursery.rand.nextInt(totalCurseWeight);
        Enchantment curse = null;
        int currentWeight = 0;
        for (Map.Entry<Enchantment, Integer> entry : curseWeightMap.entrySet()) {
            if (chosen < entry.getValue() + currentWeight) {
                curse = entry.getKey();
                break;
            }
            currentWeight += entry.getValue().intValue();
        }
        return curse;
    }

    public static void enchantManually(ItemStack stack, Enchantment enchantment, int level) {
        stack.m_41784_();
        if (!stack.m_41783_().m_128425_("Enchantments", 9)) {
            stack.m_41783_().m_128365_("Enchantments", (Tag)new ListTag());
        }
        ListTag listnbt = stack.m_41783_().m_128437_("Enchantments", 10);
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("id", String.valueOf(Registry.f_122825_.m_7981_((Object)enchantment)));
        compoundnbt.m_128376_("lvl", (short)((byte)level));
        listnbt.add((Object)compoundnbt);
    }

    public static int calculateWeightFor(Enchantment enchantment) {
        return enchantment.m_44699_().m_44716_();
    }

    static {
        rand = new Random();
        curseWeightMap = new HashMap<Enchantment, Integer>();
        totalCurseWeight = 0;
    }
}

