/*
 * Decompiled with CFR 0.152.
 */
package com.cursery.config;

import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfiguration {
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludedCUrses;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledItems;
    public final ForgeConfigSpec.ConfigValue<Boolean> excludeTreasure;
    public final ForgeConfigSpec.ConfigValue<Boolean> debugTries;
    public final ForgeConfigSpec.ConfigValue<Boolean> showDesc;
    public final ForgeConfigSpec.ConfigValue<Boolean> visualSuccess;
    public final ForgeConfigSpec.ConfigValue<Integer> basecursechance;
    public final ForgeConfigSpec ForgeConfigSpecBuilder;

    protected CommonConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("Cursery settings");
        builder.comment("Should enchanted books show a hint for curse magic, default:true");
        this.showDesc = builder.define("showDesc", true);
        builder.comment("Add a curse id here to exclude it from beeing applied. To put multiple values seperate them by commas like this:  [\"minecraft:curse\", \"mod:curse;\"] ");
        this.excludedCUrses = builder.defineList("excludedCUrses", Collections.EMPTY_LIST, e -> e instanceof String && ((String)e).contains(":"));
        builder.comment("Should applying treasure enchants be excluded, default:false");
        this.excludeTreasure = builder.define("excludeTreasure", false);
        builder.comment("Base curse application chance, scales up the more enchants the item has. Default:15 %");
        this.basecursechance = builder.defineInRange("basecursechance", 15, 1, 100);
        builder.comment("Whether to log debug messages about curse rng beeing rolled, default = false");
        this.debugTries = builder.define("debugTries", false);
        builder.comment("List of items to disable, they get replaced by air e.g. [\"minecraft:elytra\"]");
        this.disabledItems = builder.defineList("disabledItems", Collections.EMPTY_LIST, e -> e instanceof String && ((String)e).contains(":"));
        builder.comment("Should enchanting success play a sound and show particles, default:true");
        this.visualSuccess = builder.define("visualSuccess", true);
        builder.pop();
        this.ForgeConfigSpecBuilder = builder.build();
    }
}

