/*
 * Decompiled with CFR 0.152.
 */
package com.cursery.config;

import com.cursery.Cursery;
import com.cursery.config.CommonConfiguration;
import com.cursery.enchant.CurseEnchantmentHelper;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class Configuration {
    private final CommonConfiguration commonConfig = new CommonConfiguration(new ForgeConfigSpec.Builder());

    public Configuration() {
        Configuration.loadConfig(this.commonConfig.ForgeConfigSpecBuilder, FMLPaths.CONFIGDIR.get().resolve("cursery-common.toml"));
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().preserveInsertionOrder().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public CommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }

    public void parseConfig() {
        CurseEnchantmentHelper.curseWeightMap = new HashMap<Enchantment, Integer>();
        CurseEnchantmentHelper.totalCurseWeight = 0;
        HashSet<Enchantment> excluded = new HashSet<Enchantment>();
        for (String entry : (List)Cursery.config.getCommonConfig().excludedCUrses.get()) {
            ResourceLocation id = ResourceLocation.m_135820_((String)entry);
            if (id == null) {
                Cursery.LOGGER.error("Config entry could not be parsed, not a valid resource location " + entry);
                continue;
            }
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id);
            if (enchantment == null) {
                Cursery.LOGGER.error("Config entry could not be parsed, not a valid enchant" + entry);
                continue;
            }
            excluded.add(enchantment);
        }
        for (Map.Entry enchantmentEntry : ForgeRegistries.ENCHANTMENTS.getEntries()) {
            if (!((Enchantment)enchantmentEntry.getValue()).m_6589_()) continue;
            if (!excluded.contains(enchantmentEntry.getValue())) {
                int weight = CurseEnchantmentHelper.calculateWeightFor((Enchantment)enchantmentEntry.getValue());
                CurseEnchantmentHelper.totalCurseWeight += weight;
                CurseEnchantmentHelper.curseWeightMap.put((Enchantment)enchantmentEntry.getValue(), weight);
                continue;
            }
            Cursery.LOGGER.info("Excluding curse: " + ((Enchantment)enchantmentEntry.getValue()).getRegistryName() + " as config disables it");
        }
    }
}

