/*
 * Decompiled with CFR 0.152.
 */
package com.cursery.enchant;

import com.cursery.Cursery;
import com.cursery.enchant.PlayerVisualHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.registry.Registry;

public class CurseEnchantmentHelper {
    public static boolean delayNext = false;
    public static Item delayItem;
    private static Random rand;
    public static Map<Enchantment, Integer> curseWeightMap;
    public static int totalCurseWeight;
    public static ItemStack notifyStack;
    public static ServerPlayerEntity notifyPlayer;

    public static boolean checkForRandomCurse(ItemStack stack, Map<Enchantment, Integer> previous, Map<Enchantment, Integer> newEnchants) {
        if (delayNext) {
            delayNext = false;
            if (stack.func_77973_b() == delayItem) {
                return false;
            }
            delayItem = null;
        }
        if (stack == null || stack.func_190926_b() || previous == null || newEnchants == null) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() == Items.field_151134_bR) {
            return false;
        }
        int levelSum = 0;
        for (Map.Entry<Enchantment, Integer> newEnchant : newEnchants.entrySet()) {
            if (newEnchant.getKey().func_190936_d() || ((Boolean)Cursery.config.getCommonConfig().excludeTreasure.get()).booleanValue() && newEnchant.getKey().func_185261_e()) continue;
            levelSum += newEnchant.getValue().intValue();
        }
        ArrayList<Integer> addedLevels = new ArrayList<Integer>();
        boolean appliedCurse = false;
        for (Map.Entry<Enchantment, Integer> newEnchant : newEnchants.entrySet()) {
            int newLevel = previous.containsKey(newEnchant.getKey()) ? newEnchant.getValue() - previous.get(newEnchant.getKey()) : newEnchant.getValue();
            if (newLevel <= 0 || ((Boolean)Cursery.config.getCommonConfig().excludeTreasure.get()).booleanValue() && newEnchant.getKey().func_185261_e() || newEnchant.getKey().func_190936_d()) continue;
            addedLevels.add(newLevel);
        }
        for (Integer newLevel : addedLevels) {
            if (!CurseEnchantmentHelper.rollAndApplyCurseTo(stack, newLevel, levelSum - newLevel, newEnchants)) continue;
            appliedCurse = true;
        }
        if (appliedCurse) {
            if (stack == notifyStack && notifyPlayer != null) {
                PlayerVisualHelper.randomNotificationOnCurseApply(notifyPlayer, notifyStack);
                notifyPlayer = null;
                notifyStack = null;
            }
        } else if (stack == notifyStack && notifyPlayer != null) {
            PlayerVisualHelper.enchantSuccess(notifyPlayer, notifyStack);
        }
        return appliedCurse;
    }

    private static boolean rollAndApplyCurseTo(ItemStack stack, int newLevel, int levelSum, Map<Enchantment, Integer> newEnchants) {
        boolean appliedCurse = false;
        block0: for (int i = 0; i < newLevel; ++i) {
            if (((Boolean)Cursery.config.getCommonConfig().debugTries.get()).booleanValue()) {
                Cursery.LOGGER.info("Rolling new curse for " + stack + " addedEnchLevels: " + newLevel + " totalEnchantLevels: " + levelSum + " chance:" + Math.min(75, (Integer)Cursery.config.getCommonConfig().basecursechance.get() + levelSum - (stack.getItemEnchantability() >> 1)));
            }
            if (rand.nextInt(100) >= Math.min(75, (Integer)Cursery.config.getCommonConfig().basecursechance.get() + levelSum - (stack.getItemEnchantability() >> 1))) continue;
            if (((Boolean)Cursery.config.getCommonConfig().debugTries.get()).booleanValue()) {
                Cursery.LOGGER.info("Trying to apply curse to: " + stack);
            }
            for (int j = 0; j < 15; ++j) {
                int currentLevel;
                Enchantment curse = CurseEnchantmentHelper.getRandomCurse();
                if (curse == null || (currentLevel = newEnchants.getOrDefault(curse, 0).intValue()) >= curse.func_77325_b() || !curse.func_92089_a(stack) || !CurseEnchantmentHelper.isCompatibleWithAll(curse, newEnchants)) continue;
                if (((Boolean)Cursery.config.getCommonConfig().debugTries.get()).booleanValue()) {
                    Cursery.LOGGER.info("Applying curse " + curse.getRegistryName() + " to: " + stack);
                }
                CurseEnchantmentHelper.enchantManually(stack, curse, currentLevel + 1);
                newEnchants.put(curse, currentLevel + 1);
                appliedCurse = true;
                continue block0;
            }
        }
        return appliedCurse;
    }

    private static boolean isCompatibleWithAll(Enchantment enchantment, Map<Enchantment, Integer> newEnchants) {
        for (Map.Entry<Enchantment, Integer> entry : newEnchants.entrySet()) {
            if (entry.getKey().func_191560_c(enchantment)) continue;
            if (((Boolean)Cursery.config.getCommonConfig().debugTries.get()).booleanValue()) {
                Cursery.LOGGER.info("Curse " + enchantment.getRegistryName() + " is not compatible with " + entry.getKey().getRegistryName());
            }
            return false;
        }
        return true;
    }

    private static Enchantment getRandomCurse() {
        int chosen = Cursery.rand.nextInt(totalCurseWeight);
        Enchantment curse = null;
        int currentWeight = 0;
        for (Map.Entry<Enchantment, Integer> entry : curseWeightMap.entrySet()) {
            if (chosen < entry.getValue() + currentWeight) {
                curse = entry.getKey();
                break;
            }
            currentWeight += entry.getValue().intValue();
        }
        return curse;
    }

    public static void enchantManually(ItemStack stack, Enchantment enchantment, int level) {
        stack.func_196082_o();
        if (!stack.func_77978_p().func_150297_b("Enchantments", 9)) {
            stack.func_77978_p().func_218657_a("Enchantments", (INBT)new ListNBT());
        }
        ListNBT listnbt = stack.func_77978_p().func_150295_c("Enchantments", 10);
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("id", String.valueOf(Registry.field_212628_q.func_177774_c((Object)enchantment)));
        compoundnbt.func_74777_a("lvl", (short)((byte)level));
        listnbt.add((Object)compoundnbt);
    }

    public static int calculateWeightFor(Enchantment enchantment) {
        return enchantment.func_77324_c().func_185270_a();
    }

    static {
        rand = new Random();
        curseWeightMap = new HashMap<Enchantment, Integer>();
        totalCurseWeight = 0;
    }
}

