/*
 * Decompiled with CFR 0.152.
 */
package com.cursery.config;

import com.cursery.Cursery;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class CommonConfiguration {
    public List<String> excludedCurses = new ArrayList<String>();
    public boolean excludeTreasure = false;
    public boolean debugTries = false;
    public boolean showDesc = true;
    public boolean visualSuccess = true;
    public int basecursechance = 5;

    protected CommonConfiguration() {
        this.excludedCurses.add("minecraft:vanishing_curse");
    }

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Should enchanted books show a hint for curse magic, default:true");
        entry.addProperty("showDesc", Boolean.valueOf(this.showDesc));
        root.add("showDesc", (JsonElement)entry);
        JsonObject entry1 = new JsonObject();
        entry1.addProperty("desc:", "Add a curse id here to exclude it from beeing applied. To put multiple values seperate them by commas like this:  [\"minecraft:curse\", \"mod:curse;\"] ");
        JsonArray list1 = new JsonArray();
        for (String name : this.excludedCurses) {
            list1.add(name);
        }
        entry1.add("excludedCurses", (JsonElement)list1);
        root.add("excludedCurses", (JsonElement)entry1);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Should applying treasure enchants be excluded, default:false");
        entry2.addProperty("excludeTreasure", Boolean.valueOf(this.excludeTreasure));
        root.add("excludeTreasure", (JsonElement)entry2);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Base curse application chance, scales up the more enchants the item has. Default:5 %");
        entry3.addProperty("basecursechance", (Number)this.basecursechance);
        root.add("basecursechance", (JsonElement)entry3);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Whether to log debug messages about curse chances beeing rolled, default = false");
        entry4.addProperty("debugTries", Boolean.valueOf(this.debugTries));
        root.add("debugTries", (JsonElement)entry4);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Should enchanting success play a sound and show particles, default:true");
        entry5.addProperty("visualSuccess", Boolean.valueOf(this.visualSuccess));
        root.add("visualSuccess", (JsonElement)entry5);
        return root;
    }

    public void deserialize(JsonObject data) {
        if (data == null) {
            Cursery.LOGGER.error("Config file was empty!");
            return;
        }
        try {
            this.showDesc = data.get("showDesc").getAsJsonObject().get("showDesc").getAsBoolean();
            this.excludeTreasure = data.get("excludeTreasure").getAsJsonObject().get("excludeTreasure").getAsBoolean();
            this.debugTries = data.get("debugTries").getAsJsonObject().get("debugTries").getAsBoolean();
            this.visualSuccess = data.get("visualSuccess").getAsJsonObject().get("visualSuccess").getAsBoolean();
            this.basecursechance = data.get("basecursechance").getAsJsonObject().get("basecursechance").getAsInt();
            this.excludedCurses = new ArrayList<String>();
            for (JsonElement element : data.get("excludedCurses").getAsJsonObject().get("excludedCurses").getAsJsonArray()) {
                this.excludedCurses.add(element.getAsString());
            }
        }
        catch (Exception e) {
            Cursery.LOGGER.error("Could not parse config file", (Throwable)e);
        }
    }
}

