/*
 * Decompiled with CFR 0.152.
 */
package com.cursery.enchant;

import com.cursery.Cursery;
import com.cursery.enchant.PlayerVisualHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class CurseEnchantmentHelper {
    public static boolean delayNext = false;
    public static class_1792 delayItem;
    private static Random rand;
    public static Map<class_1887, Integer> curseWeightMap;
    public static int totalCurseWeight;
    public static class_1799 notifyStack;
    public static class_3222 notifyPlayer;

    public static boolean checkForRandomCurse(class_1799 stack, Map<class_1887, Integer> previous, Map<class_1887, Integer> newEnchants) {
        if (delayNext) {
            delayNext = false;
            if (stack.method_7909() == delayItem) {
                return false;
            }
            delayItem = null;
        }
        if (stack == null || stack.method_7960() || previous == null || newEnchants == null) {
            return false;
        }
        if (stack.method_7909() == class_1802.field_8529 || stack.method_7909() == class_1802.field_8598) {
            return false;
        }
        int levelSum = 0;
        for (Map.Entry<class_1887, Integer> newEnchant : newEnchants.entrySet()) {
            if (newEnchant.getKey().method_8195() || Cursery.config.getCommonConfig().excludeTreasure && newEnchant.getKey().method_8193()) continue;
            levelSum += newEnchant.getValue().intValue();
        }
        ArrayList<Integer> addedLevels = new ArrayList<Integer>();
        boolean appliedCurse = false;
        for (Map.Entry<class_1887, Integer> newEnchant : newEnchants.entrySet()) {
            int newLevel = previous.containsKey(newEnchant.getKey()) ? newEnchant.getValue() - previous.get(newEnchant.getKey()) : newEnchant.getValue();
            if (newLevel <= 0 || Cursery.config.getCommonConfig().excludeTreasure && newEnchant.getKey().method_8193() || newEnchant.getKey().method_8195()) continue;
            addedLevels.add(newLevel);
        }
        for (Integer newLevel : addedLevels) {
            if (!CurseEnchantmentHelper.rollAndApplyCurseTo(stack, newLevel, levelSum - newLevel, newEnchants)) continue;
            appliedCurse = true;
        }
        if (appliedCurse) {
            if (stack == notifyStack && notifyPlayer != null) {
                PlayerVisualHelper.randomNotificationOnCurseApply(notifyPlayer, notifyStack);
                notifyPlayer = null;
                notifyStack = null;
            }
        } else if (stack == notifyStack && notifyPlayer != null) {
            PlayerVisualHelper.enchantSuccess(notifyPlayer, notifyStack);
        }
        return appliedCurse;
    }

    private static boolean rollAndApplyCurseTo(class_1799 stack, int newLevel, int levelSum, Map<class_1887, Integer> newEnchants) {
        boolean appliedCurse = false;
        block0: for (int i = 0; i < newLevel; ++i) {
            if (Cursery.config.getCommonConfig().debugTries) {
                Cursery.LOGGER.info("Rolling new curse for " + stack + " addedEnchLevels: " + newLevel + " totalEnchantLevels: " + levelSum + " chance:" + Math.min(75, Cursery.config.getCommonConfig().basecursechance + levelSum - (stack.method_7909().method_7837() >> 1)));
            }
            if (rand.nextInt(100) >= Math.min(75, Cursery.config.getCommonConfig().basecursechance + levelSum - (stack.method_7909().method_7837() >> 1))) continue;
            if (Cursery.config.getCommonConfig().debugTries) {
                Cursery.LOGGER.info("Trying to apply curse to: " + stack);
            }
            for (int j = 0; j < 15; ++j) {
                int currentLevel;
                class_1887 curse = CurseEnchantmentHelper.getRandomCurse();
                if (curse == null || (currentLevel = newEnchants.getOrDefault(curse, 0).intValue()) >= curse.method_8183() || !curse.method_8192(stack) || !CurseEnchantmentHelper.isCompatibleWithAll(curse, newEnchants)) continue;
                if (Cursery.config.getCommonConfig().debugTries) {
                    Cursery.LOGGER.info("Applying curse " + class_7923.field_41176.method_10221((Object)curse) + " to: " + stack);
                }
                CurseEnchantmentHelper.enchantManually(stack, curse, currentLevel + 1);
                newEnchants.put(curse, currentLevel + 1);
                appliedCurse = true;
                continue block0;
            }
        }
        return appliedCurse;
    }

    private static boolean isCompatibleWithAll(class_1887 enchantment, Map<class_1887, Integer> newEnchants) {
        for (Map.Entry<class_1887, Integer> entry : newEnchants.entrySet()) {
            if (entry.getKey().method_8188(enchantment)) continue;
            if (Cursery.config.getCommonConfig().debugTries) {
                Cursery.LOGGER.info("Curse " + class_7923.field_41176.method_10221((Object)enchantment) + " is not compatible with " + class_7923.field_41176.method_10221((Object)entry.getKey()));
            }
            return false;
        }
        return true;
    }

    private static class_1887 getRandomCurse() {
        int chosen = Cursery.rand.nextInt(totalCurseWeight);
        class_1887 curse = null;
        int currentWeight = 0;
        for (Map.Entry<class_1887, Integer> entry : curseWeightMap.entrySet()) {
            if (chosen < entry.getValue() + currentWeight) {
                curse = entry.getKey();
                break;
            }
            currentWeight += entry.getValue().intValue();
        }
        return curse;
    }

    public static void enchantManually(class_1799 stack, class_1887 enchantment, int level) {
        stack.method_7948();
        if (!stack.method_7969().method_10573("Enchantments", 9)) {
            stack.method_7969().method_10566("Enchantments", (class_2520)new class_2499());
        }
        class_2499 listnbt = stack.method_7969().method_10554("Enchantments", 10);
        class_2487 compoundnbt = new class_2487();
        compoundnbt.method_10582("id", String.valueOf(class_7923.field_41176.method_10221((Object)enchantment)));
        compoundnbt.method_10575("lvl", (short)((byte)level));
        listnbt.add((Object)compoundnbt);
    }

    public static int calculateWeightFor(class_1887 enchantment) {
        return enchantment.method_8186().method_8197();
    }

    static {
        rand = new Random();
        curseWeightMap = new HashMap<class_1887, Integer>();
        totalCurseWeight = 0;
    }
}

