/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.client.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.distantfriends.client.model.FriendModel;
import com.mrbysco.distantfriends.entity.DistantFriend;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class FriendRenderer
extends MobRenderer<DistantFriend, FriendModel> {
    private final FriendModel playerModel;
    private final FriendModel slimPlayerModel;
    public static final ResourceLocation defaultTexture = DefaultPlayerSkin.m_118626_();

    public FriendRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public FriendRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (EntityModel)new FriendModel(context.m_174023_(ModelLayers.f_171162_), slim), 0.0f);
        this.playerModel = new FriendModel(context.m_174023_(ModelLayers.f_171162_), false);
        this.slimPlayerModel = new FriendModel(context.m_174023_(ModelLayers.f_171166_), true);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
    }

    public void render(DistantFriend playerStatue, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        this.f_115290_ = playerStatue.isSlim() ? this.slimPlayerModel : this.playerModel;
        super.m_7392_((Mob)playerStatue, entityYaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    protected void scale(DistantFriend friend, PoseStack poseStack, float partialTickTime) {
        float f = 0.9375f;
        poseStack.m_85841_(f, f, f);
    }

    public ResourceLocation getTextureLocation(DistantFriend friend) {
        return friend.getGameProfile().map(this::getSkin).orElse(defaultTexture);
    }

    private ResourceLocation getSkin(GameProfile gameProfile) {
        if (!gameProfile.isComplete()) {
            return defaultTexture;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        SkinManager skinManager = minecraft.m_91109_();
        Map loadSkinFromCache = skinManager.m_118815_(gameProfile);
        if (loadSkinFromCache.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return skinManager.m_118825_((MinecraftProfileTexture)loadSkinFromCache.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        return DefaultPlayerSkin.m_118627_((UUID)gameProfile.getId());
    }
}

