/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.distantfriends.registry.FriendRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DistantDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.m_123914_((DataProvider)new Loots(generator));
        generator.m_123914_((DataProvider)new Language(generator));
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(SlimeLootTables::new, (Object)LootContextParamSets.f_81415_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        public static class SlimeLootTables
        extends EntityLoot {
            protected void addTables() {
                this.m_124371_((EntityType)FriendRegistry.FRIEND.get(), LootTable.m_79147_());
            }

            protected Iterable<EntityType<?>> getKnownEntities() {
                Stream<EntityType> entityTypeStream = FriendRegistry.ENTITIES.getEntries().stream().map(RegistryObject::get);
                return entityTypeStream::iterator;
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "distantfriends", "en_us");
        }

        protected void addTranslations() {
            this.addEntityType((Supplier)FriendRegistry.FRIEND, "Distant Friend");
        }
    }
}

