/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.entity.goal;

import com.mrbysco.distantfriends.entity.DistantFriend;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class LookedAtGoal
extends Goal {
    private final TargetingConditions lookTargeting = TargetingConditions.m_148353_().m_26883_(256.0);
    @Nullable
    private Player player;
    private final DistantFriend friend;
    private final Random random;
    private int crouchInterval = 10;
    private int punchInterval = 5;

    public LookedAtGoal(DistantFriend friend) {
        this.friend = friend;
        this.random = friend.m_21187_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        this.player = this.friend.f_19853_.m_45946_(this.lookTargeting, (LivingEntity)this.friend);
        return this.player != null;
    }

    public boolean m_8045_() {
        if (this.player != null && !this.player.m_6084_()) {
            return false;
        }
        return this.friend.m_142538_().m_123333_((Vec3i)this.player.m_142538_()) <= 512;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.friend.m_20124_(Pose.STANDING);
        this.friend.m_21561_(false);
    }

    public void m_8041_() {
        super.m_8041_();
        this.friend.m_20124_(Pose.STANDING);
        this.friend.m_21561_(false);
    }

    public void m_8037_() {
        boolean inView = false;
        if (this.player != null) {
            boolean lookingAtMe = this.friend.isLookingAtMe(this.player);
            boolean lookedAt = this.friend.isLookedAt();
            if (lookingAtMe) {
                if (!lookedAt) {
                    this.friend.setLookedAt(true);
                    this.friend.m_21573_().m_26573_();
                }
            } else {
                this.friend.setLookedAt(false);
            }
            if (this.player.m_142582_((Entity)this.friend)) {
                inView = true;
            }
        }
        if (this.friend.isInView() != inView) {
            this.friend.setInView(inView);
        }
        if (this.friend.isLookedAt()) {
            if (this.player != null) {
                this.friend.m_21563_().m_24946_(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
            }
            if (this.friend.f_19797_ % this.crouchInterval == 0) {
                this.crouchInterval = this.random.nextInt(50) + 10;
                Pose pose = this.friend.m_6047_() ? Pose.STANDING : Pose.CROUCHING;
                this.friend.m_20124_(pose);
            }
            if (this.friend.f_19797_ % this.punchInterval == 0) {
                this.punchInterval = this.random.nextInt(25) + 10;
                this.friend.m_21561_(!this.friend.m_5912_());
            }
        }
    }
}

