/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.data;

import com.mrbysco.distantfriends.registry.FriendRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DistantDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new Loots(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(DistantDatagen::getProvider), Set.of("distantfriends")));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new Language(packOutput));
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            HolderGetter biomeHolderGetter = context.m_255420_(Registries.f_256952_);
            ForgeBiomeModifiers.AddSpawnsBiomeModifier addSpawn = ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)biomeHolderGetter.m_254956_(BiomeTags.f_215817_), (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)FriendRegistry.FRIEND.get(), 20, 1, 2));
            context.m_255272_(DistantDatagen.createKey("add_distant_friend"), (Object)addSpawn);
        });
        registryBuilder.m_254916_(Registries.f_256952_, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("distantfriends", name));
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(FriendLootProvider::new, LootContextParamSets.f_81415_)));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        public static class FriendLootProvider
        extends EntityLootSubProvider {
            protected FriendLootProvider() {
                super(FeatureFlags.f_244280_.m_247355_());
            }

            public void m_246942_() {
                this.m_245309_((EntityType)FriendRegistry.FRIEND.get(), LootTable.m_79147_());
            }

            protected Stream<EntityType<?>> getKnownEntityTypes() {
                return FriendRegistry.ENTITIES.getEntries().stream().map(RegistryObject::get);
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "distantfriends", "en_us");
        }

        protected void addTranslations() {
            this.addEntityType((Supplier)FriendRegistry.FRIEND, "Distant Friend");
        }
    }
}

