/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.dyed.mixin.client.render.entity.feature;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import dev.yurisuika.dyed.mixin.client.render.entity.feature.HorseArmorFeatureRendererAccessor;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.LeatherHorseArmorLayer;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.item.DyeableHorseArmorItem;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LeatherHorseArmorLayer.class})
public class HorseArmorFeatureRendererMixin {
    private static final Map<String, ResourceLocation> HORSE_ARMOR_TEXTURE_CACHE = Maps.newHashMap();

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/passive/HorseEntity;FFFFFF)V"}, at={@At(value="TAIL")})
    public void injectRender(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, HorseEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        ItemStack itemStack = entity.func_213803_dV();
        if (itemStack.func_77973_b() instanceof HorseArmorItem) {
            HorseArmorItem horseArmorItem = (HorseArmorItem)itemStack.func_77973_b();
            ((HorseModel)((LeatherHorseArmorLayer)this).func_215332_c()).func_217111_a(((HorseArmorFeatureRendererAccessor)((Object)this)).getModel());
            ((HorseArmorFeatureRendererAccessor)((Object)this)).getModel().func_212843_a_((AbstractHorseEntity)entity, limbAngle, limbDistance, tickDelta);
            ((HorseArmorFeatureRendererAccessor)((Object)this)).getModel().func_225597_a_((AbstractHorseEntity)entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            if (horseArmorItem instanceof DyeableHorseArmorItem) {
                int i = ((DyeableHorseArmorItem)horseArmorItem).func_200886_f(itemStack);
                float n = (float)(i >> 16 & 0xFF) / 255.0f;
                float o = (float)(i >> 8 & 0xFF) / 255.0f;
                float p = (float)(i & 0xFF) / 255.0f;
                this.renderHorseArmorParts(matrices, vertexConsumers, light, horseArmorItem, n, o, p, null);
                this.renderHorseArmorParts(matrices, vertexConsumers, light, horseArmorItem, 1.0f, 1.0f, 1.0f, "overlay");
            } else {
                this.renderHorseArmorParts(matrices, vertexConsumers, light, horseArmorItem, 1.0f, 1.0f, 1.0f, null);
            }
        }
    }

    private void renderHorseArmorParts(MatrixStack matrices, IRenderTypeBuffer vertexConsumerProvider, int light, HorseArmorItem name, float red, float green, float blue, @Nullable String overlay) {
        ((HorseArmorFeatureRendererAccessor)((Object)this)).getModel().func_225598_a_(matrices, vertexConsumerProvider.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.getHorseArmorTexture(name, overlay))), light, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    private ResourceLocation getHorseArmorTexture(HorseArmorItem name, @Nullable String overlay) {
        return HORSE_ARMOR_TEXTURE_CACHE.computeIfAbsent(StringUtils.remove((String)String.valueOf(name.func_219976_d()), (String)".png") + (overlay == null ? "" : "_" + overlay) + ".png", ResourceLocation::new);
    }
}

