/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.dyed.mixin.client.render.entity.feature;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.yurisuika.dyed.mixin.client.render.entity.feature.HorseArmorFeatureRendererAccessor;
import java.util.Map;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.DyeableHorseArmorItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HorseArmorLayer.class})
public class HorseArmorFeatureRendererMixin {
    private static final Map<String, ResourceLocation> HORSE_ARMOR_TEXTURE_CACHE = Maps.newHashMap();

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/passive/HorseEntity;FFFFFF)V"}, at={@At(value="TAIL")})
    public void injectRender(PoseStack matrices, MultiBufferSource vertexConsumers, int light, Horse entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        ItemStack itemStack = entity.m_30722_();
        Item item = itemStack.m_41720_();
        if (item instanceof HorseArmorItem) {
            HorseArmorItem horseArmorItem = (HorseArmorItem)item;
            ((HorseModel)((HorseArmorLayer)this).m_117386_()).m_102624_(((HorseArmorFeatureRendererAccessor)((Object)this)).getModel());
            ((HorseArmorFeatureRendererAccessor)((Object)this)).getModel().m_6839_((AbstractHorse)entity, limbAngle, limbDistance, tickDelta);
            ((HorseArmorFeatureRendererAccessor)((Object)this)).getModel().m_6973_((AbstractHorse)entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            if (horseArmorItem instanceof DyeableHorseArmorItem) {
                int i = ((DyeableHorseArmorItem)horseArmorItem).m_41121_(itemStack);
                float n = (float)(i >> 16 & 0xFF) / 255.0f;
                float o = (float)(i >> 8 & 0xFF) / 255.0f;
                float p = (float)(i & 0xFF) / 255.0f;
                this.renderHorseArmorParts(matrices, vertexConsumers, light, horseArmorItem, n, o, p, null);
                this.renderHorseArmorParts(matrices, vertexConsumers, light, horseArmorItem, 1.0f, 1.0f, 1.0f, "overlay");
            } else {
                this.renderHorseArmorParts(matrices, vertexConsumers, light, horseArmorItem, 1.0f, 1.0f, 1.0f, null);
            }
        }
    }

    private void renderHorseArmorParts(PoseStack matrices, MultiBufferSource vertexConsumerProvider, int light, HorseArmorItem name, float red, float green, float blue, @Nullable String overlay) {
        ((HorseArmorFeatureRendererAccessor)((Object)this)).getModel().m_7695_(matrices, vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)this.getHorseArmorTexture(name, overlay))), light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private ResourceLocation getHorseArmorTexture(HorseArmorItem name, @Nullable String overlay) {
        return HORSE_ARMOR_TEXTURE_CACHE.computeIfAbsent(StringUtils.remove((String)String.valueOf(name.m_41367_()), (String)".png") + (String)(overlay == null ? "" : "_" + overlay) + ".png", ResourceLocation::new);
    }
}

