/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.ScreenHelper;
import de.markusbordihn.easynpc.data.action.ActionData;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.menu.DialogMenu;
import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class DialogScreen
extends AbstractContainerScreen<DialogMenu> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final EasyNPCEntity entity;
    protected final Map<ActionType, ActionData> actions;
    protected final UUID uuid;
    protected Button yesDialogButton = null;
    protected Button noDialogButton = null;
    protected float xMouse;
    protected float yMouse;
    private List<FormattedCharSequence> cachedDialogComponents = Collections.emptyList();
    protected DialogType dialogType = DialogType.BASIC;
    protected String dialog;
    protected TextComponent dialogComponent;
    protected int numberOfDialogLines = 1;

    public DialogScreen(DialogMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.entity = menu.getEntity();
        this.actions = this.entity.getActions();
        this.uuid = this.entity.m_142081_();
    }

    protected void renderDialog(PoseStack poseStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_DIALOG);
        int minNumberOfLines = Math.max(2, this.numberOfDialogLines);
        Objects.requireNonNull(this.f_96547_);
        int backgroundHeight = minNumberOfLines * (9 + 2);
        int backgroundLeftPos = this.f_97735_ + 70;
        int backgroundTopPos = this.f_97736_ + 15;
        int backgroundTopHeight = Math.min(Math.max(30, backgroundHeight), 105);
        int backgroundBottomHeight = Math.max(backgroundHeight - backgroundTopHeight, 15);
        int backgroundBottomPos = Math.max(116 - backgroundBottomHeight, 15);
        this.m_93228_(poseStack, backgroundLeftPos, backgroundTopPos, 0, 0, 200, backgroundTopHeight);
        this.m_93228_(poseStack, backgroundLeftPos, backgroundTopPos + backgroundTopHeight, 0, backgroundBottomPos, 200, backgroundBottomHeight);
        if (!this.cachedDialogComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfDialogLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.cachedDialogComponents.get(line);
                float f = (float)this.f_97735_ + 87.0f;
                float f2 = (float)this.f_97736_ + 22.0f;
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92877_(poseStack, formattedCharSequence, f, f2 + (float)(line * (9 + 2)), 0);
            }
        }
    }

    private void setDialog(String text) {
        if (text == null || text.isBlank()) {
            return;
        }
        Minecraft minecraft = this.f_96541_;
        this.dialog = DialogUtils.parseDialog(text, (LivingEntity)this.entity, (Player)(minecraft != null ? minecraft.f_91074_ : null));
        this.dialogComponent = new TextComponent(this.dialog);
        this.cachedDialogComponents = this.f_96547_.m_92923_((FormattedText)this.dialogComponent, 176);
        Objects.requireNonNull(this.f_96547_);
        this.numberOfDialogLines = Math.min(128 / 9, this.cachedDialogComponents.size());
    }

    protected static Button menuButton(int left, int top, int width, String label, Button.OnPress onPress) {
        return DialogScreen.menuButton(left, top, width, (Component)new TranslatableComponent("text.easy_npc.config." + label), onPress);
    }

    protected static Button menuButton(int left, int top, int width, Component label, Button.OnPress onPress) {
        return new Button(left, top, width, 20, label, onPress);
    }

    public void closeScreen() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft != null) {
            minecraft.m_91152_((Screen)null);
        }
    }

    public void m_7856_() {
        if (this.entity == null) {
            return;
        }
        super.m_7856_();
        this.f_97727_ = 200;
        this.f_97726_ = 275;
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.dialogType = this.entity.getDialogType();
        this.setDialog(this.entity.getDialog());
        if (this.actions.containsKey((Object)ActionType.ON_OPEN_DIALOG)) {
            NetworkMessage.triggerAction(this.uuid, ActionType.ON_OPEN_DIALOG);
        }
        if (this.dialogType == DialogType.YES_NO) {
            Objects.requireNonNull(this.f_96547_);
            int dialogButtonTop = this.f_97736_ + 55 + this.numberOfDialogLines * 9;
            String yesDialogButtonText = TextUtils.limitString(this.entity.getYesDialogButton(), 32);
            String noDialogButtonText = TextUtils.limitString(this.entity.getNoDialogButton(), 32);
            boolean smallButtonLayout = yesDialogButtonText.length() < 16 && noDialogButtonText.length() < 16;
            this.yesDialogButton = (Button)this.m_142416_((GuiEventListener)DialogScreen.menuButton(this.f_97735_ + 70, dialogButtonTop, smallButtonLayout ? 95 : 198, (Component)new TextComponent(yesDialogButtonText), onPress -> {
                String yesDialogText = this.entity.getYesDialog();
                if (!yesDialogText.isBlank()) {
                    this.setDialog(yesDialogText);
                    this.yesDialogButton.f_93624_ = false;
                    this.noDialogButton.f_93624_ = false;
                } else {
                    this.closeScreen();
                }
                if (this.actions.containsKey((Object)ActionType.ON_YES_SELECTION)) {
                    NetworkMessage.triggerAction(this.uuid, ActionType.ON_YES_SELECTION);
                }
            }));
            this.noDialogButton = (Button)this.m_142416_((GuiEventListener)DialogScreen.menuButton(smallButtonLayout ? this.yesDialogButton.f_93620_ + this.yesDialogButton.m_5711_() + 10 : this.yesDialogButton.f_93620_, smallButtonLayout ? dialogButtonTop : dialogButtonTop + 25, smallButtonLayout ? 95 : 198, (Component)new TextComponent(noDialogButtonText), onPress -> {
                String noDialogText = this.entity.getNoDialog();
                if (!noDialogText.isBlank()) {
                    this.setDialog(noDialogText);
                    this.yesDialogButton.f_93624_ = false;
                    this.noDialogButton.f_93624_ = false;
                } else {
                    this.closeScreen();
                }
                if (this.actions.containsKey((Object)ActionType.ON_NO_SELECTION)) {
                    NetworkMessage.triggerAction(this.uuid, ActionType.ON_NO_SELECTION);
                }
            }));
        }
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        if (this.entity == null) {
            return;
        }
        super.m_6305_(poseStack, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
        int avatarPositionTop = 55 + this.entity.getEntityDialogTop();
        int left = this.f_97735_ + 40;
        int top = this.f_97736_ + 70 + avatarPositionTop;
        ScreenHelper.renderEntityDialog(left, top, Math.round((double)(left - 140) - (double)this.xMouse * 0.25), Math.round((double)(top - 120) - (double)this.yMouse * 0.5), this.entity);
        this.renderDialog(poseStack);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 250, 170);
        this.m_93228_(poseStack, this.f_97735_ + 243, this.f_97736_, 215, 0, 35, 170);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 60, 0, 30, 250, 140);
        this.m_93228_(poseStack, this.f_97735_ + 243, this.f_97736_ + 60, 215, 30, 35, 140);
    }

    public void m_7379_() {
        if (this.actions.containsKey((Object)ActionType.ON_CLOSE_DIALOG)) {
            NetworkMessage.triggerAction(this.uuid, ActionType.ON_CLOSE_DIALOG);
        }
        super.m_7379_();
    }
}

