/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.main;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.ScreenHelper;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationType;
import de.markusbordihn.easynpc.menu.configuration.main.MainConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MainConfigurationScreen
extends ConfigurationScreen<MainConfigurationMenu> {
    protected Button editActionButton = null;
    protected Button editDialogButton = null;
    protected Button editEquipmentButton = null;
    protected Button editPoseButton = null;
    protected Button editPositionButton = null;
    protected Button editRotationButton = null;
    protected Button editScalingButton = null;
    protected Button editSkinButton = null;
    protected Button exportButton = null;
    protected Button importButton = null;
    protected Button removeEntityButton = null;
    protected Button saveNameButton = null;
    private EditBox nameBox;
    private String formerName = "";

    public MainConfigurationScreen(MainConfigurationMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void saveName() {
        String value = this.nameBox.m_94155_();
        if (value != null && !value.isBlank()) {
            log.debug("Saving name {} for {}", (Object)value, (Object)this.entity);
            NetworkMessage.nameChange(this.uuid, value);
            this.formerName = value;
            this.saveNameButton.f_93623_ = false;
        }
    }

    public void deleteNPC() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.uuid != null) {
                NetworkMessage.removeNPC(this.uuid);
                minecraft.m_91152_((Screen)null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)new TranslatableComponent("text.easy_npc.removeNPC.deleteQuestion"), (Component)new TranslatableComponent("text.easy_npc.removeNPC.deleteWarning", new Object[]{this.entity.m_5446_().getString()}), (Component)new TranslatableComponent("text.easy_npc.removeNPC.deleteButton"), CommonComponents.f_130656_));
    }

    private void validateName() {
        String nameValue = this.nameBox.m_94155_();
        this.saveNameButton.f_93623_ = nameValue != null && !this.formerName.equals(nameValue);
    }

    private static Button menuButton(int left, int top, String label, Button.OnPress onPress) {
        return MainConfigurationScreen.menuButton(left, top, 88, label, onPress);
    }

    @Override
    public void m_7856_() {
        if (this.entity == null) {
            return;
        }
        super.m_7856_();
        int buttonLeftPosition = this.f_97735_ + 110;
        int buttonSpace = 4;
        int buttonTopPosition = this.f_97736_ + 43;
        this.homeButton.f_93624_ = false;
        this.formerName = this.entity.m_7755_().getString();
        this.nameBox = new EditBox(this.f_96547_, this.contentLeftPos + 1, this.f_97736_ + 20, 190, 18, (Component)new TranslatableComponent("Name"));
        this.nameBox.m_94199_(32);
        this.nameBox.m_94144_(this.formerName);
        this.nameBox.m_94151_(consumer -> this.validateName());
        this.m_142416_((GuiEventListener)this.nameBox);
        this.saveNameButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(this.f_97735_ + 202, this.f_97736_ + 19, "save_name", onPress -> this.saveName()));
        this.saveNameButton.f_93623_ = false;
        this.editSkinButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(this.contentLeftPos, this.f_97736_ + 194, 100, "skin", onPress -> {
            SkinType skinType = this.entity.getSkinType();
            switch (skinType) {
                case PLAYER_SKIN: 
                case SECURE_REMOTE_URL: 
                case INSECURE_REMOTE_URL: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.PLAYER_SKIN);
                    break;
                }
                case CUSTOM: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.CUSTOM_SKIN);
                    break;
                }
                default: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.DEFAULT_SKIN);
                }
            }
        }));
        this.editSkinButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.defaultSkinConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.defaultSkinConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.defaultSkinConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.playerSkinConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.playerSkinConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.playerSkinConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.customSkinConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.customSkinConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.customSkinConfigurationPermissionLevel.get());
        this.importButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(buttonLeftPosition, buttonTopPosition, "import", onPress -> NetworkMessage.openConfiguration(this.uuid, ConfigurationType.DEFAULT_PRESET_IMPORT)));
        this.exportButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(buttonLeftPosition + this.importButton.m_5711_() + buttonSpace, buttonTopPosition, "export", onPress -> NetworkMessage.openConfiguration(this.uuid, ConfigurationType.CUSTOM_PRESET_EXPORT)));
        buttonTopPosition = buttonTopPosition + 20 + buttonSpace;
        this.editDialogButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(buttonLeftPosition, buttonTopPosition, "dialog", onPress -> {
            DialogType dialogType = this.entity.getDialogType();
            switch (dialogType) {
                case NONE: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.NONE_DIALOG);
                    break;
                }
                case BASIC: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.BASIC_DIALOG);
                    break;
                }
                case YES_NO: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.YES_NO_DIALOG);
                    break;
                }
                default: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.BASIC_DIALOG);
                }
            }
        }));
        this.editDialogButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.basicDialogConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.basicDialogConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.basicDialogConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.yesNoDialogConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.yesNoDialogConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.yesNoDialogConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.noneDialogConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.noneDialogConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.noneDialogConfigurationPermissionLevel.get());
        this.editActionButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(this.editDialogButton.f_93620_ + this.editDialogButton.m_5711_() + buttonSpace, buttonTopPosition, "actions", onPress -> NetworkMessage.openConfiguration(this.uuid, ConfigurationType.BASIC_ACTION)));
        this.editActionButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.basicActionConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.basicActionConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.basicActionConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.dialogActionConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.dialogActionConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.dialogActionConfigurationPermissionLevel.get());
        buttonTopPosition = buttonTopPosition + 20 + buttonSpace;
        this.editEquipmentButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(buttonLeftPosition, buttonTopPosition, "equipment", onPress -> NetworkMessage.openConfiguration(this.uuid, ConfigurationType.EQUIPMENT)));
        this.editEquipmentButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.equipmentConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.equipmentConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.equipmentConfigurationPermissionLevel.get());
        this.editScalingButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(this.editEquipmentButton.f_93620_ + this.editEquipmentButton.m_5711_() + buttonSpace, buttonTopPosition, "scaling", onPress -> NetworkMessage.openConfiguration(this.uuid, ConfigurationType.SCALING)));
        this.editScalingButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.scalingConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.scalingConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.scalingConfigurationPermissionLevel.get());
        buttonTopPosition = buttonTopPosition + 20 + buttonSpace;
        this.editPoseButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(buttonLeftPosition, buttonTopPosition, "pose", onPress -> {
            ModelPose modelPose = this.entity.getModelPose();
            switch (modelPose) {
                case CUSTOM: {
                    if (!(this.entity.getModelHeadPosition().isZero() && this.entity.getModelBodyPosition().isZero() && this.entity.getModelLeftArmPosition().isZero() && this.entity.getModelRightArmPosition().isZero() && this.entity.getModelLeftLegPosition().isZero() && this.entity.getModelRightLegPosition().isZero())) {
                        NetworkMessage.openConfiguration(this.uuid, ConfigurationType.CUSTOM_POSE);
                        break;
                    }
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.ADVANCED_POSE);
                    break;
                }
                case DEFAULT: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.DEFAULT_POSE);
                    break;
                }
                default: {
                    NetworkMessage.openConfiguration(this.uuid, ConfigurationType.DEFAULT_POSE);
                }
            }
        }));
        this.editPoseButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.defaultPoseConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.defaultPoseConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.defaultPoseConfigurationPermissionLevel.get()) || this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.customPoseConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.customPoseConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.customPoseConfigurationPermissionLevel.get());
        this.editPositionButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(this.editPoseButton.f_93620_ + this.editPoseButton.m_5711_() + buttonSpace, buttonTopPosition, "position", onPress -> NetworkMessage.openConfiguration(this.uuid, ConfigurationType.DEFAULT_POSITION)));
        this.editPositionButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.defaultPositionConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.defaultPositionConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.defaultPositionConfigurationPermissionLevel.get());
        buttonTopPosition = buttonTopPosition + 20 + buttonSpace;
        this.editRotationButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(buttonLeftPosition, buttonTopPosition, "rotation", onPress -> NetworkMessage.openConfiguration(this.uuid, ConfigurationType.DEFAULT_ROTATION)));
        this.editRotationButton.f_93623_ = this.hasPermissions((Boolean)MainConfigurationScreen.COMMON.defaultRotationConfigurationEnabled.get(), (Boolean)MainConfigurationScreen.COMMON.defaultRotationConfigurationAllowInCreative.get(), (Integer)MainConfigurationScreen.COMMON.defaultRotationConfigurationPermissionLevel.get());
        this.removeEntityButton = (Button)this.m_142416_((GuiEventListener)MainConfigurationScreen.menuButton(this.rightPos - 60, this.bottomPos - 30, 50, "delete", onPress -> this.deleteNPC()));
        this.removeEntityButton.setFGColor(0xFF5555);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
        ScreenHelper.renderScaledEntityAvatar(this.f_97735_ + 55, this.f_97736_ + 185, 55, (float)(this.f_97735_ + 50) - this.xMouse, (float)(this.f_97736_ + 90) - this.yMouse, this.entity);
        float scaleEntityTypeText = 0.8f;
        poseStack.m_85836_();
        poseStack.m_85841_(scaleEntityTypeText, scaleEntityTypeText, scaleEntityTypeText);
        this.f_96547_.m_92889_(poseStack, this.entity.m_6095_().m_20676_(), ((float)this.contentLeftPos + 3.0f) / scaleEntityTypeText, ((float)this.f_97736_ + 48.0f) / scaleEntityTypeText, 0x404040);
        poseStack.m_85849_();
        if (this.entity.hasOwner()) {
            this.f_96547_.m_92883_(poseStack, "Owner: " + this.entity.getOwnerName(), (float)this.contentLeftPos + 2.0f, (float)this.f_97736_ + 220.0f, 0x404040);
        }
    }

    @Override
    protected void m_7027_(PoseStack poseStack, int x, int y) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int avatarTopPos = this.f_97736_ + 43;
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)avatarTopPos, (int)(this.f_97735_ + 107), (int)(avatarTopPos + 137), (int)-16777216);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 8), (int)(avatarTopPos + 1), (int)(this.f_97735_ + 106), (int)(avatarTopPos + 136), (int)-1);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(avatarTopPos + 15), (int)(this.f_97735_ + 107), (int)(avatarTopPos + 152), (int)-16777216);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.f_97735_ + 8), (int)(avatarTopPos + 16), (int)(this.f_97735_ + 106), (int)(avatarTopPos + 151), (int)-5592406);
    }
}

