/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String LOG_PREFIX = "[Player Texture Manager]";
    private static Path textureCachePath = null;
    private static HashMap<TextureModelKey, ResourceLocation> playerTextureCache = new HashMap();
    private static HashMap<TextureModelKey, SkinType> playerTextureSkinTypeCache = new HashMap();
    private static HashMap<TextureModelKey, String> playerTextureSkinURLCache = new HashMap();
    private static HashSet<UUID> playerTextureReloadProtection = new HashSet();

    protected PlayerTextureManager() {
    }

    public static Map<TextureModelKey, ResourceLocation> getPlayerTextureCache() {
        return playerTextureCache;
    }

    public static Set<UUID> getPlayerTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : playerTextureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || !PlayerTextureManager.hasPlayerTextureSkinData(textureModelKey)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static SkinType getPlayerTextureSkinType(TextureModelKey textureModelKey) {
        return playerTextureSkinTypeCache.get(textureModelKey);
    }

    public static String getPlayerTextureSkinURL(TextureModelKey textureModelKey) {
        return playerTextureSkinURLCache.get(textureModelKey);
    }

    public static boolean hasPlayerTextureSkinData(TextureModelKey textureModelKey) {
        return playerTextureSkinTypeCache.containsKey(textureModelKey) && playerTextureSkinURLCache.containsKey(textureModelKey);
    }

    public static ResourceLocation getOrCreateTextureWithDefault(EasyNPCEntity entity, ResourceLocation defaultResourceLocation) {
        Optional skinUUID = entity.getSkinUUID();
        if (!skinUUID.isPresent()) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey((UUID)skinUUID.get(), entity.getSkinModel());
        ResourceLocation resourceLocation = playerTextureCache.get(textureModelKey);
        if (resourceLocation != null) {
            if (!PlayerTextureManager.hasPlayerTextureSkinData(textureModelKey)) {
                playerTextureSkinTypeCache.put(textureModelKey, entity.getSkinType());
                playerTextureSkinURLCache.put(textureModelKey, entity.getSkinURL());
            }
            return resourceLocation;
        }
        ResourceLocation createdResourceLocation = PlayerTextureManager.createTexture(textureModelKey, entity);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static ResourceLocation createTexture(TextureModelKey textureModelKey, EasyNPCEntity entity) {
        return PlayerTextureManager.createTexture(textureModelKey, entity.getSkinType(), entity.getSkinURL());
    }

    private static ResourceLocation createTexture(TextureModelKey textureModelKey, SkinType skinType, String skinURL) {
        SkinModel skinModel = textureModelKey.getSkinModel();
        String targetDirectory = PlayerTextureManager.getTextureCacheDirectory(skinModel).toString();
        ResourceLocation localTextureCache = TextureManager.getCachedTexture(textureModelKey, targetDirectory);
        if (localTextureCache != null) {
            playerTextureCache.put(textureModelKey, localTextureCache);
            playerTextureSkinTypeCache.put(textureModelKey, skinType);
            playerTextureSkinURLCache.put(textureModelKey, skinURL);
            return localTextureCache;
        }
        UUID skinUUID = textureModelKey.getUUID();
        if (playerTextureReloadProtection.contains(skinUUID)) {
            return null;
        }
        playerTextureReloadProtection.add(skinUUID);
        String textureSkinURL = null;
        switch (skinType) {
            case PLAYER_SKIN: {
                textureSkinURL = PlayersUtils.getUserTexture(skinUUID);
                break;
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                if (!PlayersUtils.isValidUrl(skinURL)) break;
                textureSkinURL = skinURL;
                break;
            }
        }
        if (textureSkinURL == null || textureSkinURL.isEmpty()) {
            return null;
        }
        ResourceLocation resourceLocation = TextureManager.addRemoteTexture(textureModelKey, textureSkinURL, targetDirectory);
        playerTextureCache.put(textureModelKey, resourceLocation);
        playerTextureSkinTypeCache.put(textureModelKey, skinType);
        playerTextureSkinURLCache.put(textureModelKey, textureSkinURL);
        return resourceLocation;
    }

    private static Path getTextureCacheDirectory(SkinModel skinModel) {
        Path cacheDirectory;
        if (textureCachePath == null) {
            cacheDirectory = Paths.get(TextureManager.getTextureCacheDirectory().toString(), "player");
            if (!cacheDirectory.toFile().exists()) {
                log.info("{} Creating player texture cache directory at {}", (Object)LOG_PREFIX, (Object)cacheDirectory);
                FileUtils.getOrCreateDirectory((Path)cacheDirectory, (String)"easy_npc");
            }
            textureCachePath = cacheDirectory;
        }
        if (!(cacheDirectory = Paths.get(textureCachePath.toString(), skinModel.name())).toFile().exists()) {
            log.info("{} Creating player texture model cache directory at {}", (Object)LOG_PREFIX, (Object)cacheDirectory);
            FileUtils.getOrCreateDirectory((Path)cacheDirectory, (String)"easy_npc");
        }
        return cacheDirectory;
    }
}

