/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.commands.CustomCommand;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public class ConfigureCommand
extends CustomCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"configure").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).suggests(CustomCommand::suggestEasyNPCs).executes(context -> ConfigureCommand.configure((CommandSourceStack)context.getSource(), UuidArgument.m_113853_((CommandContext)context, (String)"uuid"))));
    }

    private static int configure(CommandSourceStack context, UUID uuid) throws CommandSyntaxException {
        ServerPlayer serverPlayer = context.m_81375_();
        if (uuid == null) {
            return 0;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid);
        if (easyNPCEntity == null) {
            context.m_81352_((Component)new TextComponent("EasyNPC with UUID " + uuid + " not found!"));
            return 0;
        }
        if (!serverPlayer.m_7500_() && !easyNPCEntity.isOwner(serverPlayer)) {
            context.m_81352_((Component)new TextComponent("You are not the owner of this EasyNPC!"));
            return 0;
        }
        easyNPCEntity.openMainConfigurationMenu(serverPlayer);
        return 1;
    }
}

