/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.easynpc.commands.CustomCommand;
import de.markusbordihn.easynpc.data.WorldPresetData;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class PresetCommand
extends CustomCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"preset").requires(commandSourceStack -> commandSourceStack.m_6761_(0))).executes(PresetCommand::overview)).then(Commands.m_82127_((String)"export").then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).suggests(CustomCommand::suggestEasyNPCs).executes(context -> PresetCommand.exportPreset((CommandSourceStack)context.getSource(), UuidArgument.m_113853_((CommandContext)context, (String)"uuid")))))).then(Commands.m_82127_((String)"import").then(Commands.m_82129_((String)"presetLocation", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CustomCommand::suggestPresets).executes(context -> PresetCommand.importPreset((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"presetLocation")))));
    }

    private static int overview(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Preset command is not implemented yet!"), false);
        return 0;
    }

    private static int exportPreset(CommandSourceStack context, UUID uuid) throws CommandSyntaxException {
        ServerPlayer serverPlayer = context.m_81375_();
        if (uuid == null) {
            return 0;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid);
        if (easyNPCEntity == null) {
            context.m_81352_((Component)new TextComponent("EasyNPC with UUID " + uuid + " not found!"));
            return 0;
        }
        if (!serverPlayer.m_7500_() && !easyNPCEntity.isOwner(serverPlayer)) {
            context.m_81352_((Component)new TextComponent("You are not the owner of this EasyNPC!"));
            return 0;
        }
        log.info("Exporting EasyNPC {} with UUID {} and skin {}...", (Object)easyNPCEntity.m_7755_(), (Object)uuid, (Object)easyNPCEntity.getSkinModel());
        NetworkMessage.exportPresetClient(uuid, serverPlayer);
        return 1;
    }

    private static int importPreset(CommandSourceStack context, ResourceLocation preset) {
        EntityType entityType;
        CompoundTag compoundTag;
        if (preset == null) {
            return 0;
        }
        Path presetPath = WorldPresetData.getPresetsResourceLocationPath(preset);
        log.info("Importing preset {} {}...", (Object)preset, (Object)presetPath);
        if (!presetPath.toFile().exists()) {
            context.m_81352_((Component)new TextComponent("Preset file " + preset + " not found!"));
            return 0;
        }
        try {
            compoundTag = NbtIo.m_128937_((File)presetPath.toFile());
        }
        catch (IOException exception) {
            context.m_81352_((Component)new TextComponent("Unable to read data from preset " + preset + "!"));
            return 0;
        }
        if (compoundTag == null) {
            context.m_81352_((Component)new TextComponent("Data from preset " + preset + " are empty!"));
            return 0;
        }
        EntityType entityType2 = entityType = compoundTag.m_128441_("id") ? (EntityType)EntityType.m_20632_((String)compoundTag.m_128461_("id")).orElse(null) : null;
        if (entityType == null) {
            context.m_81352_((Component)new TextComponent("Unable to get entity type from preset " + preset + "!"));
            return 0;
        }
        log.info("Importing preset {} {} {} ...", (Object)preset, (Object)compoundTag, (Object)entityType);
        UUID uuid = compoundTag.m_128441_("UUID") ? compoundTag.m_128342_("UUID") : null;
        boolean existingUUID = uuid != null && EntityManager.getEasyNPCEntityByUUID(uuid) != null;
        Entity entity = entityType.m_20615_((Level)context.m_81372_());
        if (entity instanceof EasyNPCEntity) {
            EasyNPCEntity easyNPCEntity = (EasyNPCEntity)entity;
            easyNPCEntity.importPreset(compoundTag);
            context.m_81372_().m_7967_(entity);
            if (existingUUID) {
                context.m_81354_((Component)new TextComponent("Updated preset " + preset + " to " + easyNPCEntity), false);
            } else {
                context.m_81354_((Component)new TextComponent("Imported preset " + preset + " to " + easyNPCEntity), false);
            }
            return 1;
        }
        context.m_81352_((Component)new TextComponent("Preset " + preset + " is not valid!"));
        return 0;
    }
}

