/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data;

import de.markusbordihn.easynpc.data.CustomDataHandler;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomPresetData {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String DATA_FOLDER_NAME = "preset";

    protected CustomPresetData() {
    }

    public static void registerCustomPresetData(FMLClientSetupEvent event) {
        event.enqueueWork(CustomPresetData::prepareFolder);
    }

    public static void prepareFolder() {
        log.info("{} custom preset data ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Path presetDataFolder = CustomPresetData.getPresetDataFolder();
        if (presetDataFolder == null) {
            return;
        }
        log.info("{} custom preset data folder at {} ...", (Object)"\ud83d\udde3 Create Easy NPC", (Object)presetDataFolder);
        for (SkinModel skinModel : SkinModel.values()) {
            Path presetModelFolder = CustomPresetData.getPresetDataFolder(skinModel);
            if (presetModelFolder == null) continue;
            log.info("{} preset model folder {} at {} ...", (Object)"\ud83d\udde3 Create Easy NPC", (Object)skinModel, (Object)presetModelFolder);
        }
    }

    public static Path getPresetDataFolder() {
        return CustomDataHandler.getOrCreateCustomDataFolder(DATA_FOLDER_NAME);
    }

    public static Path getPresetDataFolder(SkinModel skinModel) {
        Path skinDataFolder = CustomPresetData.getPresetDataFolder();
        String skinModelName = skinModel.name();
        if (skinDataFolder != null && skinModelName != null) {
            return FileUtils.getOrCreateDirectory((Path)skinDataFolder.resolve(skinModelName.toLowerCase()), (String)skinModelName.toLowerCase());
        }
        return null;
    }

    public static File getPresetFile(SkinModel skinModel, String fileName) {
        Path presetModelFolder = CustomPresetData.getPresetDataFolder(skinModel);
        if (presetModelFolder != null && fileName != null && !fileName.isEmpty()) {
            return presetModelFolder.resolve((String)((fileName = fileName.toLowerCase().replaceAll("[^a-z0-9/._-]", "").replace("..", "")).endsWith(".npc.nbt") ? fileName : fileName + ".npc.nbt")).toFile();
        }
        return null;
    }

    public static File getPresetFile(SkinModel skinModel, UUID uuid) {
        return CustomPresetData.getPresetFile(skinModel, uuid.toString());
    }

    public static Stream<Path> getPresetFilePathLocations() {
        Stream<Path> stream;
        block8: {
            Path presetDataFolder = CustomPresetData.getPresetDataFolder();
            Stream<Path> filesStream = Files.walk(presetDataFolder, new FileVisitOption[0]);
            try {
                List filePaths = filesStream.filter(path -> path.toString().endsWith(".npc.nbt")).filter(path -> Pattern.matches("[a-z0-9/._-]+", path.getFileName().toString())).map(path -> path).collect(Collectors.toList());
                stream = filePaths.stream();
                if (filesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (filesStream != null) {
                        try {
                            filesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    log.error("Could not read preset data folder {}!", (Object)presetDataFolder, (Object)exception);
                    return Stream.empty();
                }
            }
            filesStream.close();
        }
        return stream;
    }
}

