/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.npc;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.npc.Fairy;
import de.markusbordihn.easynpc.entity.npc.Humanoid;
import de.markusbordihn.easynpc.entity.npc.HumanoidSlim;
import de.markusbordihn.easynpc.entity.npc.Skeleton;
import de.markusbordihn.easynpc.entity.npc.Villager;
import de.markusbordihn.easynpc.entity.npc.Zombie;
import de.markusbordihn.easynpc.entity.npc.ZombieVillager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntityType {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"easy_npc");
    public static final RegistryObject<EntityType<Fairy>> FAIRY = ENTITIES.register("fairy", () -> EntityType.Builder.m_20704_(Fairy::new, (MobCategory)EasyNPCEntity.CATEGORY).m_20699_(1.0f, 2.0f).m_20702_(8).m_20712_("fairy"));
    public static final RegistryObject<EntityType<Humanoid>> HUMANOID = ModEntityType.registerHumanoid("humanoid", Humanoid.Variant.STEVE);
    public static final RegistryObject<EntityType<HumanoidSlim>> HUMANOID_SLIM = ModEntityType.registerHumanoidSlim("humanoid_slim", HumanoidSlim.Variant.ALEX);
    public static final RegistryObject<EntityType<Skeleton>> SKELETON = ENTITIES.register("skeleton", () -> EntityType.Builder.m_20704_(Skeleton::new, (MobCategory)EasyNPCEntity.CATEGORY).m_20699_(1.0f, 2.0f).m_20702_(8).m_20712_("skeleton"));
    public static final RegistryObject<EntityType<Villager>> VILLAGER = ENTITIES.register("villager", () -> EntityType.Builder.m_20704_(Villager::new, (MobCategory)EasyNPCEntity.CATEGORY).m_20699_(1.0f, 2.0f).m_20702_(8).m_20712_("villager"));
    public static final RegistryObject<EntityType<Zombie>> ZOMBIE = ENTITIES.register("zombie", () -> EntityType.Builder.m_20704_(Zombie::new, (MobCategory)EasyNPCEntity.CATEGORY).m_20699_(1.0f, 2.0f).m_20702_(8).m_20712_("zombie"));
    public static final RegistryObject<EntityType<ZombieVillager>> ZOMBIE_VILLAGER = ENTITIES.register("zombie_villager", () -> EntityType.Builder.m_20704_(ZombieVillager::new, (MobCategory)EasyNPCEntity.CATEGORY).m_20699_(1.0f, 2.0f).m_20702_(8).m_20712_("zombie_villager"));

    protected ModEntityType() {
    }

    @SubscribeEvent
    public static final void entityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)FAIRY.get(), Fairy.createAttributes().m_22265_());
        event.put((EntityType)HUMANOID.get(), Humanoid.createAttributes().m_22265_());
        event.put((EntityType)HUMANOID_SLIM.get(), HumanoidSlim.createAttributes().m_22265_());
        event.put((EntityType)SKELETON.get(), Skeleton.createAttributes().m_22265_());
        event.put((EntityType)VILLAGER.get(), Villager.createAttributes().m_22265_());
        event.put((EntityType)ZOMBIE.get(), Zombie.createAttributes().m_22265_());
        event.put((EntityType)ZOMBIE_VILLAGER.get(), ZombieVillager.createAttributes().m_22265_());
    }

    public static RegistryObject<EntityType<Humanoid>> registerHumanoid(String id, Enum<?> variant) {
        return ENTITIES.register(id, () -> EntityType.Builder.m_20704_((entityType, level) -> new Humanoid((EntityType<? extends EasyNPCEntity>)entityType, level, variant), (MobCategory)EasyNPCEntity.CATEGORY).m_20699_(1.0f, 2.0f).m_20702_(8).m_20712_(id));
    }

    public static RegistryObject<EntityType<HumanoidSlim>> registerHumanoidSlim(String id, Enum<?> variant) {
        return ENTITIES.register(id, () -> EntityType.Builder.m_20704_((entityType, level) -> new HumanoidSlim((EntityType<? extends EasyNPCEntity>)entityType, level, variant), (MobCategory)EasyNPCEntity.CATEGORY).m_20699_(1.0f, 2.0f).m_20702_(8).m_20712_(id));
    }
}

