/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Villager
extends EasyNPCEntity {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    public static final String ID = "villager";
    public static final String NAME = "Villager";

    public Villager(EntityType<? extends EasyNPCEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.VILLAGER;
    }

    @Override
    public boolean hasBodyModelPart() {
        return true;
    }

    @Override
    public boolean hasArmsModelPart() {
        return true;
    }

    @Override
    public boolean hasLeftArmModelPart() {
        return false;
    }

    @Override
    public boolean hasRightArmModelPart() {
        return false;
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public boolean canUseOffHand() {
        return false;
    }

    @Override
    public Component m_7755_() {
        Component component = this.m_7770_();
        if (component != null) {
            return TextUtils.removeAction(component);
        }
        Component professionName = this.getProfessionName();
        Component variantName = this.getVariantName();
        return new TextComponent(variantName.getString() + " (" + professionName.getString() + ")");
    }

    @Override
    public boolean hasProfessions() {
        return true;
    }

    @Override
    public boolean hasProfession() {
        return true;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.DEFAULT;
    }

    @Override
    public Enum<?> getVariant(String name) {
        return Variant.valueOf(name);
    }

    public static enum Variant {
        DEFAULT,
        DESERT,
        JUNGLE,
        PLAINS,
        SAVANNA,
        SNOW,
        SWAMP,
        TAIGA;

    }
}

