/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogMenu
extends AbstractContainerMenu {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected EasyNPCEntity entity;
    protected UUID uuid;

    public DialogMenu(int windowId, Inventory playerInventory, UUID uuid) {
        this((MenuType)ModMenuTypes.DIALOG_MENU.get(), windowId, playerInventory, uuid);
    }

    public DialogMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, data.m_130259_());
    }

    public DialogMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, UUID uuid) {
        super(menuType, windowId);
        this.uuid = uuid;
        this.entity = EntityManager.getEasyNPCEntityByUUID(uuid);
        log.debug("Open Dialog menu for {}: {} with player inventory {}", (Object)this.uuid, (Object)this.entity, (Object)playerInventory);
    }

    public EasyNPCEntity getEntity() {
        return this.entity;
    }

    public static MenuProvider getMenuProvider(final UUID uuid, final Entity entity) {
        return new MenuProvider(){

            public Component m_5446_() {
                return entity.m_7755_();
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player serverPlayer) {
                return new DialogMenu(windowId, inventory, uuid);
            }
        };
    }

    public boolean m_6875_(Player player) {
        return player != null && player.m_6084_() && this.entity != null && this.entity.m_6084_();
    }
}

