/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.CustomPosition;
import de.markusbordihn.easynpc.data.action.ActionData;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.entity.Profession;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationType;
import de.markusbordihn.easynpc.network.NetworkHandler;
import de.markusbordihn.easynpc.network.message.MessageActionChange;
import de.markusbordihn.easynpc.network.message.MessageDialogTypeChange;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import de.markusbordihn.easynpc.network.message.MessageModelLockRotationChange;
import de.markusbordihn.easynpc.network.message.MessageModelPoseChange;
import de.markusbordihn.easynpc.network.message.MessageModelPositionChange;
import de.markusbordihn.easynpc.network.message.MessageModelVisibilityChange;
import de.markusbordihn.easynpc.network.message.MessageNameChange;
import de.markusbordihn.easynpc.network.message.MessageOpenConfiguration;
import de.markusbordihn.easynpc.network.message.MessagePoseChange;
import de.markusbordihn.easynpc.network.message.MessagePositionChange;
import de.markusbordihn.easynpc.network.message.MessagePresetExport;
import de.markusbordihn.easynpc.network.message.MessagePresetExportClient;
import de.markusbordihn.easynpc.network.message.MessagePresetExportWorld;
import de.markusbordihn.easynpc.network.message.MessagePresetImport;
import de.markusbordihn.easynpc.network.message.MessagePresetImportWorld;
import de.markusbordihn.easynpc.network.message.MessageProfessionChange;
import de.markusbordihn.easynpc.network.message.MessageRemoveNPC;
import de.markusbordihn.easynpc.network.message.MessageRotationChange;
import de.markusbordihn.easynpc.network.message.MessageSaveBasicDialog;
import de.markusbordihn.easynpc.network.message.MessageSaveYesNoDialog;
import de.markusbordihn.easynpc.network.message.MessageScaleChange;
import de.markusbordihn.easynpc.network.message.MessageSkinChange;
import de.markusbordihn.easynpc.network.message.MessageTriggerAction;
import de.markusbordihn.easynpc.network.message.MessageVariantChange;
import java.util.UUID;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkMessage {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    protected NetworkMessage() {
    }

    public static void actionChange(UUID uuid, ActionData actionData) {
        if (uuid != null && actionData != null && actionData.isValid()) {
            NetworkHandler.sendToServer(new MessageActionChange(uuid, actionData));
        }
    }

    public static void nameChange(UUID uuid, String name) {
        if (uuid != null && name != null && !name.isEmpty()) {
            NetworkHandler.sendToServer(new MessageNameChange(uuid, name));
        }
    }

    public static void openConfiguration(UUID uuid, Enum<ConfigurationType> configurationType) {
        if (uuid != null && configurationType != null) {
            NetworkHandler.sendToServer(new MessageOpenConfiguration(uuid, configurationType.name()));
        }
    }

    public static void modelLockRotationChange(UUID uuid, boolean lockRotation) {
        if (uuid != null) {
            NetworkHandler.sendToServer(new MessageModelLockRotationChange(uuid, lockRotation));
        }
    }

    public static void modelPoseChange(UUID uuid, ModelPose modelPose) {
        if (uuid != null && modelPose != null) {
            NetworkHandler.sendToServer(new MessageModelPoseChange(uuid, modelPose));
        }
    }

    public static void modelPositionChange(UUID uuid, ModelPart modelPart, CustomPosition position) {
        if (uuid != null && modelPart != null && position != null) {
            NetworkHandler.sendToServer(new MessageModelPositionChange(uuid, modelPart, position));
        }
    }

    public static void modelVisibilityChange(UUID uuid, ModelPart modelPart, boolean visible) {
        if (uuid != null && modelPart != null) {
            NetworkHandler.sendToServer(new MessageModelVisibilityChange(uuid, modelPart, visible));
        }
    }

    public static void poseChange(UUID uuid, Pose pose) {
        if (uuid != null && pose != null) {
            NetworkHandler.sendToServer(new MessagePoseChange(uuid, pose));
        }
    }

    public static void positionChange(UUID uuid, Vec3 pos) {
        if (uuid != null && pos != null) {
            NetworkHandler.sendToServer(new MessagePositionChange(uuid, pos));
        }
    }

    public static void professionChange(UUID uuid, Profession profession) {
        if (uuid != null && profession != null) {
            NetworkHandler.sendToServer(new MessageProfessionChange(uuid, profession));
        }
    }

    public static void removeNPC(UUID uuid) {
        if (uuid != null) {
            NetworkHandler.sendToServer(new MessageRemoveNPC(uuid));
        }
    }

    public static void rotationChange(UUID uuid, ModelPart modelPart, Rotations rotations) {
        if (uuid != null && modelPart != null && rotations != null) {
            NetworkHandler.sendToServer(new MessageRotationChange(uuid, modelPart, rotations));
        }
    }

    public static void changeDialogType(UUID uuid, DialogType dialogType) {
        if (uuid != null && dialogType != null) {
            NetworkHandler.sendToServer(new MessageDialogTypeChange(uuid, dialogType));
        }
    }

    public static void saveBasicDialog(UUID uuid, String dialog) {
        if (uuid != null && dialog != null) {
            NetworkHandler.sendToServer(new MessageSaveBasicDialog(uuid, dialog));
        }
    }

    public static void saveYesNoDialog(UUID uuid, String dialog, String yesDialog, String noDialog, String yesButtonText, String noButtonText) {
        if (uuid != null && dialog != null && yesDialog != null && noDialog != null) {
            NetworkHandler.sendToServer(new MessageSaveYesNoDialog(uuid, dialog, yesDialog, noDialog, yesButtonText, noButtonText));
        }
    }

    public static void scaleChange(UUID uuid, String scaleAxis, float scale) {
        if (uuid != null && scaleAxis != null) {
            NetworkHandler.sendToServer(new MessageScaleChange(uuid, scaleAxis, Float.valueOf(scale)));
        }
    }

    public static void skinChange(UUID uuid, Enum<SkinType> skinType) {
        if (uuid != null && skinType != null) {
            NetworkHandler.sendToServer(new MessageSkinChange(uuid, "", "", Constants.BLANK_UUID, skinType.name()));
        }
    }

    public static void skinChange(UUID uuid, String skin, Enum<SkinType> skinType) {
        if (uuid != null && skin != null && skinType != null) {
            NetworkHandler.sendToServer(new MessageSkinChange(uuid, skin, "", Constants.BLANK_UUID, skinType.name()));
        }
    }

    public static void skinChange(UUID uuid, String skin, String skinURL, UUID skinUUID, Enum<SkinType> skinType) {
        if (uuid != null && skin != null && skinType != null) {
            NetworkHandler.sendToServer(new MessageSkinChange(uuid, skin, skinURL, skinUUID, skinType.name()));
        }
    }

    public static void triggerAction(UUID uuid, ActionType actionType) {
        if (uuid != null && actionType != null && actionType != ActionType.NONE) {
            NetworkHandler.sendToServer(new MessageTriggerAction(uuid, actionType.name()));
        }
    }

    public static void variantChange(UUID uuid, Enum<?> variant) {
        if (uuid != null && variant != null) {
            NetworkHandler.sendToServer(new MessageVariantChange(uuid, variant.name()));
        }
    }

    public static void exportPreset(UUID uuid, String name) {
        if (uuid != null && name != null && !name.isEmpty()) {
            NetworkHandler.sendToServer(new MessagePresetExport(uuid, name));
        }
    }

    public static void exportPresetWorld(UUID uuid, String name) {
        if (uuid != null && name != null && !name.isEmpty()) {
            NetworkHandler.sendToServer(new MessagePresetExportWorld(uuid, name));
        }
    }

    public static void exportPresetClient(UUID uuid, String name, ServerPlayer serverPlayer) {
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (uuid != null && easyNPCEntity != null) {
            log.info("Exporting preset for {} to {}", (Object)easyNPCEntity.m_7755_().getString(), (Object)serverPlayer.m_7755_().getString());
            NetworkHandler.sendToPlayer(new MessagePresetExportClient(uuid, easyNPCEntity.m_7755_().getString(), easyNPCEntity.getSkinModel().name(), name, easyNPCEntity.exportPreset()), serverPlayer);
        }
    }

    public static void exportPresetClient(UUID uuid, ServerPlayer serverPlayer) {
        NetworkMessage.exportPresetClient(uuid, uuid.toString(), serverPlayer);
    }

    public static void importWorldPreset(UUID uuid, ResourceLocation resourceLocation) {
        if (uuid != null && resourceLocation != null) {
            NetworkHandler.sendToServer(new MessagePresetImportWorld(uuid, resourceLocation));
        }
    }

    public static void importPreset(UUID uuid, CompoundTag compoundTag) {
        if (uuid != null && compoundTag != null) {
            NetworkHandler.sendToServer(new MessagePresetImport(uuid, compoundTag));
        }
    }
}

