/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageModelLockRotationChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final boolean lockRotation;

    public MessageModelLockRotationChange(UUID uuid, boolean lockRotation) {
        this.uuid = uuid;
        this.lockRotation = lockRotation;
    }

    public boolean getLockRotation() {
        return this.lockRotation;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageModelLockRotationChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelLockRotationChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelLockRotationChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        boolean lockRotation = message.getLockRotation();
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Reset and lock rotation {} for {} from {}", (Object)lockRotation, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.setModelLockRotation(lockRotation);
    }
}

