/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.CustomPosition;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageModelPositionChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final ModelPart modelPart;
    protected final CustomPosition position;

    public MessageModelPositionChange(UUID uuid, ModelPart modelPart, float x, float y, float z) {
        this(uuid, modelPart, new CustomPosition(x, y, z));
    }

    public MessageModelPositionChange(UUID uuid, ModelPart modelPart, CustomPosition position) {
        this.uuid = uuid;
        this.modelPart = modelPart;
        this.position = position;
    }

    public ModelPart getModelPart() {
        return this.modelPart;
    }

    public CustomPosition getPosition() {
        return this.position;
    }

    public float getX() {
        return this.position.x();
    }

    public float getY() {
        return this.position.y();
    }

    public float getZ() {
        return this.position.z();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageModelPositionChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageModelPositionChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageModelPositionChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        ModelPart modelPart = message.getModelPart();
        if (modelPart == null) {
            log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            return;
        }
        CustomPosition position = message.getPosition();
        if (position == null) {
            log.error("Invalid position {} for {} from {}", (Object)position, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change {} position to {}\u00b0 for {} from {}", (Object)modelPart, (Object)position, (Object)easyNPCEntity, (Object)serverPlayer);
        switch (modelPart) {
            case HEAD: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelHeadPosition(position);
                break;
            }
            case BODY: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelBodyPosition(position);
                break;
            }
            case ARMS: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelArmsPosition(position);
                break;
            }
            case LEFT_ARM: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelLeftArmPosition(position);
                break;
            }
            case RIGHT_ARM: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelRightArmPosition(position);
                break;
            }
            case LEFT_LEG: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelLeftLegPosition(position);
                break;
            }
            case RIGHT_LEG: {
                easyNPCEntity.m_20124_(Pose.STANDING);
                easyNPCEntity.setModelPose(ModelPose.CUSTOM);
                easyNPCEntity.setModelRightLegPosition(position);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                log.error("Invalid modelPart {} for {} from {}", (Object)modelPart, (Object)message, (Object)serverPlayer);
            }
        }
    }
}

