/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagePositionChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final Vec3 pos;

    public MessagePositionChange(UUID uuid, float x, float y, float z) {
        this(uuid, new Vec3((double)x, (double)y, (double)z));
    }

    public MessagePositionChange(UUID uuid, Vec3 pos) {
        this.uuid = uuid;
        this.pos = pos;
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public float getX() {
        return (float)this.pos.f_82479_;
    }

    public float getY() {
        return (float)this.pos.f_82480_;
    }

    public float getZ() {
        return (float)this.pos.f_82481_;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessagePositionChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePositionChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePositionChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        Vec3 pos = message.getPos();
        if (pos == null) {
            log.error("Invalid pos {} for {} from {}", (Object)pos, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change pos {} for {} from {}", (Object)pos, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.m_146884_(pos);
    }
}

