/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.WorldPresetData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagePresetExportWorld {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String name;

    public MessagePresetExportWorld(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public static void handle(MessagePresetExportWorld message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePresetExportWorld.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePresetExportWorld message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String name = message.getName();
        if (name == null || name.isEmpty()) {
            log.warn("Export preset name is empty for {}", (Object)uuid);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        SkinModel skinModel = easyNPCEntity.getSkinModel();
        if (skinModel == null) {
            log.warn("Export preset skin model is empty for {}", (Object)uuid);
            return;
        }
        CompoundTag data = easyNPCEntity.exportPreset();
        if (data == null) {
            log.warn("Export preset data is empty for {}", (Object)uuid);
            return;
        }
        File presetFile = WorldPresetData.getPresetFile(skinModel, name);
        log.info("Exporting EasyNPC {} with UUID {} and skin {} to {}", (Object)name, (Object)uuid, (Object)skinModel, (Object)presetFile);
        try {
            NbtIo.m_128944_((CompoundTag)data, (File)presetFile);
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC " + name + " with UUID " + uuid + " and skin " + skinModel + " to " + presetFile, (Throwable)exception);
        }
    }
}

