/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.action.ActionData;
import de.markusbordihn.easynpc.data.action.ActionType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageTriggerAction {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final String actionType;
    protected final UUID uuid;

    public MessageTriggerAction(UUID uuid, String actionType) {
        this.uuid = uuid;
        this.actionType = actionType;
    }

    public String getActionType() {
        return this.actionType;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageTriggerAction message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageTriggerAction.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageTriggerAction message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || uuid == null) {
            log.error("Unable to trigger action with message {} from {}", (Object)message, (Object)context);
            return;
        }
        ActionType actionType = ActionType.get(message.getActionType());
        if (actionType == null || actionType == ActionType.NONE) {
            log.error("Invalid action type {} for {} from {}", (Object)actionType, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPCEntity == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        ActionData actionData = easyNPCEntity.getActionData(actionType);
        if (actionData == null) {
            log.error("Unknown trigger action {} request for UUID {} from {}", (Object)actionType, (Object)uuid, (Object)serverPlayer);
            return;
        }
        int permissionLevel = easyNPCEntity.getActionPermissionLevel();
        log.debug("Trigger action {} for {} from {} with permission level {} ...", (Object)actionData, (Object)easyNPCEntity, (Object)serverPlayer, (Object)permissionLevel);
        easyNPCEntity.executeAction(actionData, serverPlayer);
    }
}

