/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import de.markusbordihn.easynpc.client.model.CustomModelHelper;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomVillagerModel<T extends Entity>
extends VillagerModel<T> {
    private final ModelPart arms;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public CustomVillagerModel(ModelPart modelPart) {
        super(modelPart);
        this.arms = modelPart.m_171324_("arms");
        this.body = modelPart.m_171324_("body");
        this.head = modelPart.m_171324_("head");
        this.leftLeg = modelPart.m_171324_("left_leg");
        this.rightLeg = modelPart.m_171324_("right_leg");
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof EasyNPCEntity) {
            EasyNPCEntity easyNPCEntity = (EasyNPCEntity)entity;
            CustomModelHelper.resetRotation(this.body);
            CustomModelHelper.resetRotation(this.head);
            CustomModelHelper.setRotation(this.arms, -0.8f, 0.0f, 0.0f);
            CustomModelHelper.resetRotation(this.leftLeg);
            CustomModelHelper.resetRotation(this.rightLeg);
            CustomModelHelper.resetPosition(this.body);
            CustomModelHelper.resetPosition(this.head);
            CustomModelHelper.setPosition(this.arms, 0.0f, 2.0f, 0.0f);
            CustomModelHelper.setPosition(this.leftLeg, 1.9f, 12.0f, 0.0f);
            CustomModelHelper.setPosition(this.rightLeg, -1.9f, 12.0f, 0.0f);
            this.body.f_104207_ = true;
            this.head.f_104207_ = true;
            this.arms.f_104207_ = true;
            this.leftLeg.f_104207_ = true;
            this.rightLeg.f_104207_ = true;
            if (easyNPCEntity.getModelPose() == ModelPose.CUSTOM) {
                CustomModelHelper.setHeadPositionRotationVisibility(this.head, easyNPCEntity.getModelHeadPosition(), easyNPCEntity.getModelHeadRotation(), easyNPCEntity.isModelHeadVisible(), netHeadYaw, headPitch);
                CustomModelHelper.setPositionRotationVisibility(this.body, easyNPCEntity.getModelBodyPosition(), easyNPCEntity.getModelBodyRotation(), easyNPCEntity.isModelBodyVisible());
                CustomModelHelper.setPositionRotationVisibility(this.arms, easyNPCEntity.getModelArmsPosition(), easyNPCEntity.getModelArmsRotation(), easyNPCEntity.isModelArmsVisible());
                CustomModelHelper.setPositionRotationVisibility(this.rightLeg, easyNPCEntity.getModelRightLegPosition(), easyNPCEntity.getModelRightLegRotation(), easyNPCEntity.isModelRightLegVisible());
                CustomModelHelper.setPositionRotationVisibility(this.leftLeg, easyNPCEntity.getModelLeftLegPosition(), easyNPCEntity.getModelLeftLegRotation(), easyNPCEntity.isModelLeftLegVisible());
            } else if (easyNPCEntity.m_20089_() == Pose.CROUCHING) {
                this.arms.f_104203_ += 0.4f;
                this.arms.f_104201_ = 5.2f;
                this.body.f_104203_ = 0.5f;
                this.body.f_104201_ = 3.2f;
                this.head.f_104201_ = 4.2f;
                this.leftLeg.f_104201_ = 12.2f;
                this.leftLeg.f_104202_ = 4.0f;
                this.rightLeg.f_104201_ = 12.2f;
                this.rightLeg.f_104202_ = 4.0f;
            }
            if (easyNPCEntity.getModelPose() != ModelPose.CUSTOM && easyNPCEntity.m_20089_() != Pose.CROUCHING) {
                super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }
}

