/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.Profession;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;

public class ScreenHelper {
    public static void renderEntity(int x, int y, int scale, float yRot, float xRot, EasyNPCEntity entity) {
        Minecraft minecraft = Minecraft.m_91087_();
        float f = (float)Math.atan(yRot / 40.0f);
        float f1 = (float)Math.atan(xRot / 40.0f);
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack1 = new PoseStack();
        poseStack1.m_85837_(0.0, 0.0, 1000.0);
        poseStack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(f1 * 20.0f);
        quaternion.m_80148_(quaternion1);
        poseStack1.m_85845_(quaternion);
        Component entityCustomName = entity.m_7770_();
        boolean entityShouldShowName = entity.m_6052_();
        float entityXRot = entity.m_146909_();
        float entityYBodyRot = entity.f_20883_;
        float entityYHeadRot = entity.f_20885_;
        float entityYHeadRotO = entity.f_20886_;
        float entityYRot = entity.m_146908_();
        entity.f_20883_ = 180.0f + f * 20.0f;
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-f1 * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        boolean minecraftHideGui = false;
        if (minecraft != null) {
            minecraftHideGui = minecraft.f_91066_.f_92062_;
            minecraft.f_91066_.f_92062_ = true;
        } else {
            entity.m_6593_(null);
            entity.m_20340_(false);
        }
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.m_80157_();
        entityRenderDispatcher.m_114412_(quaternion1);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multiBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack1, (MultiBufferSource)multiBuffer, 0xF000F0);
        multiBuffer.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        if (minecraft != null) {
            minecraft.f_91066_.f_92062_ = minecraftHideGui;
        }
        entity.f_20883_ = entityYBodyRot;
        entity.m_146922_(entityYRot);
        entity.m_146926_(entityXRot);
        entity.f_20885_ = entityYHeadRot;
        entity.f_20886_ = entityYHeadRotO;
        if (minecraft != null) {
            minecraft.f_91066_.f_92062_ = minecraftHideGui;
        } else {
            entity.m_6593_(entityCustomName);
            entity.m_20340_(entityShouldShowName);
        }
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    public static void renderScaledEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPCEntity entity) {
        float entityScaleX = entity.getScaleX().floatValue();
        float entityScaleY = entity.getScaleY().floatValue();
        float entityScaleZ = entity.getScaleZ().floatValue();
        Rotations entityModelRootRotation = entity.getModelRootRotation();
        boolean entityInvisible = entity.m_20145_();
        entity.setScaleX(entity.getDefaultScaleX());
        entity.setScaleY(entity.getDefaultScaleY());
        entity.setScaleZ(entity.getDefaultScaleZ());
        entity.setModelRootRotation(new Rotations(0.0f, 0.0f, 0.0f));
        entity.m_6842_(false);
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, entity);
        entity.setScaleX(Float.valueOf(entityScaleX));
        entity.setScaleY(Float.valueOf(entityScaleY));
        entity.setScaleZ(Float.valueOf(entityScaleZ));
        entity.setModelRootRotation(entityModelRootRotation);
        entity.m_6842_(entityInvisible);
    }

    public static void renderCustomPoseEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPCEntity entity) {
        ModelPose entityModelPose = entity.getModelPose();
        Pose entityPose = entity.m_20089_();
        entity.setModelPose(ModelPose.CUSTOM);
        entity.m_20124_(Pose.STANDING);
        ScreenHelper.renderScaledEntityAvatar(x, y, scale, yRot, xRot, entity);
        entity.setModelPose(entityModelPose);
        entity.m_20124_(entityPose);
    }

    public static void renderEntityAvatar(int x, int y, float yRot, float xRot, EasyNPCEntity entity) {
        ScreenHelper.renderEntity(x, y, entity.getEntityGuiScaling(), yRot, xRot, entity);
    }

    public static void renderEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPCEntity entity) {
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, entity);
    }

    public static void renderEntityAvatarForScaling(int x, int y, int scale, float yRot, float xRot, EasyNPCEntity entity) {
        Rotations entityModelRootRotation = entity.getModelRootRotation();
        boolean entityInvisible = entity.m_20145_();
        entity.setModelRootRotation(new Rotations(0.0f, 0.0f, 0.0f));
        entity.m_6842_(false);
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, entity);
        entity.setModelRootRotation(entityModelRootRotation);
        entity.m_6842_(entityInvisible);
    }

    public static void renderEntityDialog(int x, int y, float yRot, float xRot, EasyNPCEntity entity) {
        ScreenHelper.renderScaledEntityAvatar(x, y, entity.getEntityDialogScaling(), yRot, xRot, entity);
    }

    public static void renderEntityPlayerSkin(int x, int y, float yRot, float xRot, EasyNPCEntity entity, UUID userUUID, SkinType skinType) {
        SkinType entitySkinType = entity.getSkinType();
        Optional entitySkinUUID = entity.getSkinUUID();
        boolean entityPreview = entity.isPreview();
        entity.setSkinType(skinType);
        entity.setSkinUUID(userUUID);
        entity.setPreview(true);
        ScreenHelper.renderScaledEntityAvatar(x, y, entity.getEntityGuiScaling(), yRot, xRot, entity);
        entity.setSkinType(entitySkinType);
        entity.setSkinUUID(entitySkinUUID);
        entity.setPreview(entityPreview);
    }

    public static void renderEntityDefaultSkin(int x, int y, float yRot, float xRot, EasyNPCEntity entity, Enum<?> variant, Profession profession) {
        SkinType entitySkinType = entity.getSkinType();
        Enum<?> entityVariant = entity.getVariant();
        Profession entityProfession = entity.getProfession();
        entity.setSkinType(SkinType.DEFAULT);
        entity.setVariant(variant);
        entity.setProfession(profession);
        ScreenHelper.renderScaledEntityAvatar(x, y, entity.getEntityGuiScaling(), yRot, xRot, entity);
        entity.setSkinType(entitySkinType);
        entity.setVariant(entityVariant);
        entity.setProfession(entityProfession);
    }
}

