/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Checkbox
extends AbstractButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("easy_npc", "textures/gui/checkbox.png");
    protected final OnChange onChange;
    private boolean selected;
    private final boolean showLabel;
    private final Minecraft minecraft;
    private final Font font;

    public Checkbox(int left, int top, String label, boolean selected, OnChange onChange) {
        this(left, top, (Component)(!label.isBlank() ? Component.m_237115_((String)("text.easy_npc.config." + label)) : Component.m_237113_((String)"")), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, boolean selected) {
        this(left, top, (Component)Component.m_237115_((String)("text.easy_npc.config." + label)), selected, true);
    }

    public Checkbox(int left, int top, Component component, boolean selected, boolean showLabel) {
        this(left, top, component, selected, showLabel, null);
    }

    public Checkbox(int left, int top, Component component, boolean selected, boolean showLabel, OnChange onChange) {
        super(left, top, 16, 16, component);
        this.selected = selected;
        this.showLabel = showLabel;
        this.minecraft = Minecraft.m_91087_();
        this.font = this.minecraft.f_91062_;
        this.onChange = onChange;
    }

    public void m_5691_() {
        this.selected = !this.selected;
        this.onChange.onChange(this);
    }

    public boolean selected() {
        return this.selected;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void m_6303_(PoseStack poseStack, int unused1, int unused2, float unused3) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Checkbox.m_93133_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (float)(this.m_198029_() ? 16.0f : 0.0f), (float)(this.selected ? 16.0f : 0.0f), (int)16, (int)16, (int)32, (int)32);
        if (this.showLabel) {
            this.font.m_92889_(poseStack, this.m_6035_(), (float)this.f_93620_ + 18.0f, (float)this.f_93621_ + (float)(this.f_93619_ - 8) / 2.0f, 0x404040);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnChange {
        public void onChange(Checkbox var1);
    }
}

