/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.config;

import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;

    private CommonConfig() {
    }

    public static String getEnableComment(String name) {
        return "Enable " + name + " configuration.";
    }

    public static String getAllowInCreativeComment(String name) {
        return "Allow " + name + " configuration in creative mode.";
    }

    public static String getPermissionLevelComment(String name) {
        return name + " configuration permission level. (0 = everyone, 1 = moderator, 2 = gamemaster, 3 = admin, 4 = owner)";
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} common config ...", (Object)"Easy NPC");
        try {
            FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get(), (String)"easy_npc");
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "easy_npc/easy_npc-common.toml");
    }

    public static class Config {
        public static final String MAIN_CONFIGURATION = "main";
        public final ForgeConfigSpec.BooleanValue mainConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue mainConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue mainConfigurationPermissionLevel;
        public static final String BASIC_ACTION_CONFIGURATION = "basic action";
        public final ForgeConfigSpec.BooleanValue basicActionConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue basicActionConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue basicActionConfigurationPermissionLevel;
        public static final String DIALOG_ACTION_CONFIGURATION = "dialog action";
        public final ForgeConfigSpec.BooleanValue dialogActionConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue dialogActionConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue dialogActionConfigurationPermissionLevel;
        public static final String BASIC_DIALOG_CONFIGURATION = "basic dialog";
        public final ForgeConfigSpec.BooleanValue basicDialogConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue basicDialogConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue basicDialogConfigurationPermissionLevel;
        public static final String YES_NO_DIALOG_CONFIGURATION = "yes/no dialog";
        public final ForgeConfigSpec.BooleanValue yesNoDialogConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue yesNoDialogConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue yesNoDialogConfigurationPermissionLevel;
        public static final String NONE_DIALOG_CONFIGURATION = "none dialog";
        public final ForgeConfigSpec.BooleanValue noneDialogConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue noneDialogConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue noneDialogConfigurationPermissionLevel;
        public static final String DEFAULT_SKIN_CONFIGURATION = "default skin";
        public final ForgeConfigSpec.BooleanValue defaultSkinConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultSkinConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultSkinConfigurationPermissionLevel;
        public static final String PLAYER_SKIN_CONFIGURATION = "player skin";
        public final ForgeConfigSpec.BooleanValue playerSkinConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue playerSkinConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue playerSkinConfigurationPermissionLevel;
        public static final String CUSTOM_SKIN_CONFIGURATION = "custom skin";
        public final ForgeConfigSpec.BooleanValue customSkinConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customSkinConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customSkinConfigurationPermissionLevel;
        public static final String DEFAULT_POSE_CONFIGURATION = "default pose";
        public final ForgeConfigSpec.BooleanValue defaultPoseConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultPoseConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultPoseConfigurationPermissionLevel;
        private static final String ADVANCED_POSE_CONFIGURATION = "advanced pose";
        public final ForgeConfigSpec.BooleanValue advancedPoseConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue advancedPoseConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue advancedPoseConfigurationPermissionLevel;
        public static final String CUSTOM_POSE_CONFIGURATION = "custom pose";
        public final ForgeConfigSpec.BooleanValue customPoseConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customPoseConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customPoseConfigurationPermissionLevel;
        public static final String DEFAULT_EQUIPMENT_CONFIGURATION = "equipment";
        public final ForgeConfigSpec.BooleanValue equipmentConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue equipmentConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue equipmentConfigurationPermissionLevel;
        public static final String DEFAULT_POSITION_CONFIGURATION = "position";
        public final ForgeConfigSpec.BooleanValue defaultPositionConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultPositionConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultPositionConfigurationPermissionLevel;
        public static final String DEFAULT_ROTATION_CONFIGURATION = "rotation";
        public final ForgeConfigSpec.BooleanValue defaultRotationConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultRotationConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultRotationConfigurationPermissionLevel;
        public static final String DEFAULT_SCALE_CONFIGURATION = "scale";
        public final ForgeConfigSpec.BooleanValue scalingConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue scalingConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue scalingConfigurationPermissionLevel;
        public static final String CUSTOM_EXPORT_PRESET_CONFIGURATION = "custom export preset";
        public final ForgeConfigSpec.BooleanValue customExportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customExportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customExportPresetConfigurationPermissionLevel;
        public static final String WORLD_EXPORT_PRESET_CONFIGURATION = "world export preset";
        public final ForgeConfigSpec.BooleanValue worldExportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue worldExportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue worldExportPresetConfigurationPermissionLevel;
        public static final String CUSTOM_IMPORT_PRESET_CONFIGURATION = "custom import preset";
        public final ForgeConfigSpec.BooleanValue customImportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue customImportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue customImportPresetConfigurationPermissionLevel;
        public static final String DEFAULT_IMPORT_PRESET_CONFIGURATION = "default import preset";
        public final ForgeConfigSpec.BooleanValue defaultImportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue defaultImportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue defaultImportPresetConfigurationPermissionLevel;
        public static final String WORLD_IMPORT_PRESET_CONFIGURATION = "world import preset";
        public final ForgeConfigSpec.BooleanValue worldImportPresetConfigurationEnabled;
        public final ForgeConfigSpec.BooleanValue worldImportPresetConfigurationAllowInCreative;
        public final ForgeConfigSpec.IntValue worldImportPresetConfigurationPermissionLevel;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Easy NPC");
            builder.push("General");
            builder.pop();
            builder.push("Main Configuration");
            this.mainConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(MAIN_CONFIGURATION)).define("mainConfigurationEnabled", true);
            this.mainConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(MAIN_CONFIGURATION)).define("mainConfigurationAllowInCreative", true);
            this.mainConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(MAIN_CONFIGURATION)).defineInRange("mainConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Basic Action Configuration");
            this.basicActionConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(BASIC_ACTION_CONFIGURATION)).define("basicActionConfigurationEnabled", true);
            this.basicActionConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(BASIC_ACTION_CONFIGURATION)).define("basicActionConfigurationAllowInCreative", true);
            this.basicActionConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(BASIC_ACTION_CONFIGURATION)).defineInRange("basicActionConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("Dialog Action Configuration");
            this.dialogActionConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DIALOG_ACTION_CONFIGURATION)).define("dialogActionConfigurationEnabled", true);
            this.dialogActionConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DIALOG_ACTION_CONFIGURATION)).define("dialogActionConfigurationAllowInCreative", true);
            this.dialogActionConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DIALOG_ACTION_CONFIGURATION)).defineInRange("dialogActionConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("Basic Dialog Configuration");
            this.basicDialogConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(BASIC_DIALOG_CONFIGURATION)).define("basicDialogConfigurationEnabled", true);
            this.basicDialogConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(BASIC_DIALOG_CONFIGURATION)).define("basicDialogConfigurationAllowInCreative", true);
            this.basicDialogConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(BASIC_DIALOG_CONFIGURATION)).defineInRange("basicDialogConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Yes/No Dialog Configuration");
            this.yesNoDialogConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(YES_NO_DIALOG_CONFIGURATION)).define("yesNoDialogConfigurationEnabled", true);
            this.yesNoDialogConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(YES_NO_DIALOG_CONFIGURATION)).define("yesNoDialogConfigurationAllowInCreative", true);
            this.yesNoDialogConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(YES_NO_DIALOG_CONFIGURATION)).defineInRange("yesNoDialogConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("None Dialog Configuration");
            this.noneDialogConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(NONE_DIALOG_CONFIGURATION)).define("noneDialogConfigurationEnabled", true);
            this.noneDialogConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(NONE_DIALOG_CONFIGURATION)).define("noneDialogConfigurationAllowInCreative", true);
            this.noneDialogConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(NONE_DIALOG_CONFIGURATION)).defineInRange("noneDialogConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Default Skin Configuration");
            this.defaultSkinConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_SKIN_CONFIGURATION)).define("defaultSkinConfigurationEnabled", true);
            this.defaultSkinConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_SKIN_CONFIGURATION)).define("defaultSkinConfigurationAllowInCreative", true);
            this.defaultSkinConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_SKIN_CONFIGURATION)).defineInRange("defaultSkinConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Player Skin Configuration");
            this.playerSkinConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(PLAYER_SKIN_CONFIGURATION)).define("playerSkinConfigurationEnabled", true);
            this.playerSkinConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(PLAYER_SKIN_CONFIGURATION)).define("playerSkinConfigurationAllowInCreative", true);
            this.playerSkinConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(PLAYER_SKIN_CONFIGURATION)).defineInRange("playerSkinConfigurationPermissionLevel", 1, 0, 4);
            builder.pop();
            builder.push("Custom Skin Configuration");
            this.customSkinConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_SKIN_CONFIGURATION)).define("customSkinConfigurationEnabled", true);
            this.customSkinConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_SKIN_CONFIGURATION)).define("customSkinConfigurationAllowInCreative", true);
            this.customSkinConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_SKIN_CONFIGURATION)).defineInRange("customSkinConfigurationPermissionLevel", 2, 0, 4);
            builder.pop();
            builder.push("Default Pose Configuration");
            this.defaultPoseConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_POSE_CONFIGURATION)).define("defaultPoseConfigurationEnabled", true);
            this.defaultPoseConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_POSE_CONFIGURATION)).define("defaultPoseConfigurationAllowInCreative", true);
            this.defaultPoseConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_POSE_CONFIGURATION)).defineInRange("defaultPoseConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Advanced Pose Configuration");
            this.advancedPoseConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(ADVANCED_POSE_CONFIGURATION)).define("advancedPoseConfigurationEnabled", true);
            this.advancedPoseConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(ADVANCED_POSE_CONFIGURATION)).define("advancedPoseConfigurationAllowInCreative", true);
            this.advancedPoseConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(ADVANCED_POSE_CONFIGURATION)).defineInRange("advancedPoseConfigurationPermissionLevel", 0, 0, 4);
            builder.push("Custom Pose Configuration");
            this.customPoseConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_POSE_CONFIGURATION)).define("customPoseConfigurationEnabled", true);
            this.customPoseConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_POSE_CONFIGURATION)).define("customPoseConfigurationAllowInCreative", true);
            this.customPoseConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_POSE_CONFIGURATION)).defineInRange("customPoseConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Equipment Configuration");
            this.equipmentConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_EQUIPMENT_CONFIGURATION)).define("equipmentConfigurationEnabled", true);
            this.equipmentConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_EQUIPMENT_CONFIGURATION)).define("equipmentConfigurationAllowInCreative", true);
            this.equipmentConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_EQUIPMENT_CONFIGURATION)).defineInRange("equipmentConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Position Configuration");
            this.defaultPositionConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_POSITION_CONFIGURATION)).define("defaultPositionConfigurationEnabled", true);
            this.defaultPositionConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_POSITION_CONFIGURATION)).define("defaultPositionConfigurationAllowInCreative", true);
            this.defaultPositionConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_POSITION_CONFIGURATION)).defineInRange("defaultPositionConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Rotation Configuration");
            this.defaultRotationConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_ROTATION_CONFIGURATION)).define("defaultRotationConfigurationEnabled", true);
            this.defaultRotationConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_ROTATION_CONFIGURATION)).define("defaultRotationConfigurationAllowInCreative", true);
            this.defaultRotationConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_ROTATION_CONFIGURATION)).defineInRange("defaultRotationConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Scale Configuration");
            this.scalingConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_SCALE_CONFIGURATION)).define("scaleConfigurationEnabled", true);
            this.scalingConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_SCALE_CONFIGURATION)).define("scaleConfigurationAllowInCreative", true);
            this.scalingConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_SCALE_CONFIGURATION)).defineInRange("scaleConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Export Custom Preset Configuration");
            this.customExportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_EXPORT_PRESET_CONFIGURATION)).define("customExportPresetConfigurationEnabled", true);
            this.customExportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_EXPORT_PRESET_CONFIGURATION)).define("customExportPresetConfigurationAllowInCreative", true);
            this.customExportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_EXPORT_PRESET_CONFIGURATION)).defineInRange("customExportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Export World Preset Configuration");
            this.worldExportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(WORLD_EXPORT_PRESET_CONFIGURATION)).define("worldExportPresetConfigurationEnabled", true);
            this.worldExportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(WORLD_EXPORT_PRESET_CONFIGURATION)).define("worldExportPresetConfigurationAllowInCreative", true);
            this.worldExportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(WORLD_EXPORT_PRESET_CONFIGURATION)).defineInRange("worldExportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Import Custom Preset Configuration");
            this.customImportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(CUSTOM_IMPORT_PRESET_CONFIGURATION)).define("customImportPresetConfigurationEnabled", true);
            this.customImportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(CUSTOM_IMPORT_PRESET_CONFIGURATION)).define("customImportPresetConfigurationAllowInCreative", true);
            this.customImportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(CUSTOM_IMPORT_PRESET_CONFIGURATION)).defineInRange("customImportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Import Default Preset Configuration");
            this.defaultImportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(DEFAULT_IMPORT_PRESET_CONFIGURATION)).define("defaultImportPresetConfigurationEnabled", true);
            this.defaultImportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(DEFAULT_IMPORT_PRESET_CONFIGURATION)).define("defaultImportPresetConfigurationAllowInCreative", true);
            this.defaultImportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(DEFAULT_IMPORT_PRESET_CONFIGURATION)).defineInRange("defaultImportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
            builder.push("Import Server Preset Configuration");
            this.worldImportPresetConfigurationEnabled = builder.comment(CommonConfig.getEnableComment(WORLD_IMPORT_PRESET_CONFIGURATION)).define("worldImportPresetConfigurationEnabled", true);
            this.worldImportPresetConfigurationAllowInCreative = builder.comment(CommonConfig.getAllowInCreativeComment(WORLD_IMPORT_PRESET_CONFIGURATION)).define("worldImportPresetConfigurationAllowInCreative", true);
            this.worldImportPresetConfigurationPermissionLevel = builder.comment(CommonConfig.getPermissionLevelComment(WORLD_IMPORT_PRESET_CONFIGURATION)).defineInRange("worldImportPresetConfigurationPermissionLevel", 0, 0, 4);
            builder.pop();
        }
    }
}

