/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data;

import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.data.CustomDataHandler;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomSkinData {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String DATA_FOLDER_NAME = "skin";

    protected CustomSkinData() {
    }

    public static void registerCustomSkinData(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            CustomSkinData.prepareFolder();
            CustomSkinData.registerTextureFiles();
        });
    }

    public static void prepareFolder() {
        log.info("{} custom skin data ...", (Object)"\ud83d\udde3 Register Easy NPC");
        Path skinDataFolder = CustomSkinData.getSkinDataFolder();
        if (skinDataFolder == null) {
            return;
        }
        log.info("{} custom skin data folder at {} ...", (Object)"\ud83d\udde3 Create Easy NPC", (Object)skinDataFolder);
        block12: for (SkinModel skinModel : SkinModel.values()) {
            Path skinModelFolder = CustomSkinData.getSkinDataFolder(skinModel);
            if (skinModelFolder == null) continue;
            log.info("{} skin model folder {} at {} ...", (Object)"\ud83d\udde3 Create Easy NPC", (Object)skinModel, (Object)skinModelFolder);
            switch (skinModel) {
                case ALLAY: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/allay/allay_example.png"), skinModelFolder.resolve("allay_example.png").toFile());
                    continue block12;
                }
                case FAIRY: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/fairy/fairy_example.png"), skinModelFolder.resolve("fairy_example.png").toFile());
                    continue block12;
                }
                case HUMANOID: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/humanoid/humanoid_example.png"), skinModelFolder.resolve("humanoid_example.png").toFile());
                    continue block12;
                }
                case HUMANOID_SLIM: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/humanoid_slim/humanoid_slim_example.png"), skinModelFolder.resolve("humanoid_slim_example.png").toFile());
                    continue block12;
                }
                case ILLAGER: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/illager/illager_example.png"), skinModelFolder.resolve("illager_example.png").toFile());
                    continue block12;
                }
                case IRON_GOLEM: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/iron_golem/iron_golem_example.png"), skinModelFolder.resolve("iron_golem_example.png").toFile());
                    continue block12;
                }
                case SKELETON: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/skeleton/skeleton_example.png"), skinModelFolder.resolve("skeleton_example.png").toFile());
                    continue block12;
                }
                case VILLAGER: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/villager/villager_example.png"), skinModelFolder.resolve("villager_example.png").toFile());
                    continue block12;
                }
                case ZOMBIE: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/zombie/zombie_example.png"), skinModelFolder.resolve("zombie_example.png").toFile());
                    continue block12;
                }
                case ZOMBIE_VILLAGER: {
                    CustomDataHandler.copyResourceFile(new ResourceLocation("easy_npc", "textures/entity/zombie_villager/zombie_villager_example.png"), skinModelFolder.resolve("zombie_villager_example.png").toFile());
                    continue block12;
                }
            }
        }
    }

    public static void registerTextureFiles() {
        Path skinDataFolder = CustomSkinData.getSkinDataFolder();
        if (skinDataFolder == null) {
            return;
        }
        log.info("{} custom skins from {} ...", (Object)"\ud83d\udde3 Register Easy NPC", (Object)skinDataFolder);
        for (SkinModel skinModel : SkinModel.values()) {
            Path skinModelFolder = CustomSkinData.getSkinDataFolder(skinModel);
            if (skinModelFolder == null || skinModelFolder.toFile() == null || !skinModelFolder.toFile().exists() || !skinModelFolder.toFile().isDirectory()) continue;
            for (String skinFileName : skinModelFolder.toFile().list()) {
                Path skinFilePath = skinModelFolder.resolve(skinFileName);
                File skinFile = skinFilePath.toFile();
                if (skinFile == null || !skinFile.exists() || !skinFileName.endsWith(".png")) continue;
                CustomTextureManager.registerTexture(skinModel, skinFile);
            }
        }
    }

    public static void refreshRegisterTextureFiles() {
        CustomTextureManager.clearCustomTextureCache();
        CustomSkinData.registerTextureFiles();
    }

    public static Path getSkinDataFolder() {
        return CustomDataHandler.getOrCreateCustomDataFolder(DATA_FOLDER_NAME);
    }

    public static Path getSkinDataFolder(SkinModel skinModel) {
        Path skinDataFolder = CustomSkinData.getSkinDataFolder();
        String skinModelName = skinModel.name();
        if (skinDataFolder != null && skinModelName != null) {
            return FileUtils.getOrCreateDirectory((Path)skinDataFolder.resolve(skinModelName), (String)skinModelName);
        }
        return null;
    }
}

