/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldPresetData {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String DATA_FOLDER_NAME = "preset";
    public static final File MOD_FOLDER = new File(ServerLifecycleHooks.getCurrentServer().m_129843_(LevelResource.f_78182_).toFile(), "easy_npc");
    private static ConcurrentHashMap<ResourceLocation, Path> presetResourceLocationMap = new ConcurrentHashMap();

    protected WorldPresetData() {
    }

    public static void prepareFolder() {
        log.info("{} world preset data ...", (Object)"\ud83d\udde3 Register Easy NPC");
    }

    public static Path getPresetDataFolder() {
        Path path = MOD_FOLDER.toPath().resolve(DATA_FOLDER_NAME);
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        return path;
    }

    public static Path getPresetDataFolder(SkinModel skinModel) {
        Path presetDataFolder = WorldPresetData.getPresetDataFolder();
        String skinModelName = skinModel.name();
        if (skinModelName != null) {
            Path path = presetDataFolder.resolve(skinModelName.toLowerCase());
            if (!path.toFile().exists()) {
                path.toFile().mkdirs();
            }
            return path;
        }
        return null;
    }

    public static File getPresetFile(SkinModel skinModel, String fileName) {
        Path presetModelFolder = WorldPresetData.getPresetDataFolder(skinModel);
        if (presetModelFolder != null && fileName != null && !fileName.isEmpty()) {
            return presetModelFolder.resolve((String)((fileName = fileName.toLowerCase().replaceAll("[^a-z0-9/._-]", "").replace("..", "")).endsWith(".npc.nbt") ? fileName : fileName + ".npc.nbt")).toFile();
        }
        return null;
    }

    public static File getPresetFile(SkinModel skinModel, UUID uuid) {
        return WorldPresetData.getPresetFile(skinModel, uuid.toString());
    }

    public static Stream<ResourceLocation> getPresetFilePathResourceLocations() {
        Stream<ResourceLocation> stream;
        block8: {
            Path presetDataFolder = WorldPresetData.getPresetDataFolder();
            Stream<Path> filesStream = Files.walk(presetDataFolder, new FileVisitOption[0]);
            try {
                List filePaths = filesStream.filter(path -> path.toString().endsWith(".npc.nbt")).filter(path -> Pattern.matches("[a-z0-9/._-]+", path.getFileName().toString())).map(path -> {
                    ResourceLocation resourceLocation = new ResourceLocation("easy_npc", "preset/" + presetDataFolder.relativize((Path)path).toString().replace("\\", "/"));
                    presetResourceLocationMap.put(resourceLocation, (Path)path);
                    return resourceLocation;
                }).collect(Collectors.toList());
                stream = filePaths.stream();
                if (filesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (filesStream != null) {
                        try {
                            filesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    log.error("Could not read preset data folder {}!", (Object)presetDataFolder, (Object)exception);
                    return Stream.empty();
                }
            }
            filesStream.close();
        }
        return stream;
    }

    public static Path getPresetsResourceLocationPath(ResourceLocation resourceLocation) {
        return presetResourceLocationMap.get(resourceLocation);
    }
}

