/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionData;
import de.markusbordihn.easynpc.data.action.ActionType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ActionDataHelper {
    public static final String DATA_ACTIONS_TAG = "Actions";

    public static CompoundTag setAction(CompoundTag compoundTag, ActionType actionType, ActionData actionData) {
        if (actionType != null && actionType != ActionType.NONE) {
            Map<ActionType, ActionData> actions = ActionDataHelper.readActionData(compoundTag);
            actions.put(actionType, actionData);
            return ActionDataHelper.saveActionData(actions);
        }
        return compoundTag;
    }

    public static String getAction(CompoundTag compoundTag, ActionType actionType) {
        ActionData actionData = ActionDataHelper.getActionData(compoundTag, actionType);
        if (actionData != null) {
            return actionData.getAction();
        }
        return "";
    }

    public static ActionData getActionData(CompoundTag compoundTag, ActionType actionType) {
        if (actionType != ActionType.NONE) {
            Map<ActionType, ActionData> actions = ActionDataHelper.readActionData(compoundTag);
            return actions.get((Object)actionType);
        }
        return null;
    }

    public static boolean hasAction(CompoundTag compoundTag, ActionType actionType) {
        ActionData actionData = ActionDataHelper.getActionData(compoundTag, actionType);
        if (actionData != null) {
            return actionData.hasAction();
        }
        return false;
    }

    public static CompoundTag saveActionData(Map<ActionType, ActionData> actions) {
        CompoundTag compoundTag = new CompoundTag();
        ActionDataHelper.saveActionData(compoundTag, actions);
        return compoundTag;
    }

    public static CompoundTag saveActionData(CompoundTag compoundTag, Map<ActionType, ActionData> actions) {
        if (actions != null && !actions.isEmpty()) {
            ListTag listTag = new ListTag();
            for (Map.Entry<ActionType, ActionData> actionEntry : actions.entrySet()) {
                ActionData actionData;
                ActionType actionType = actionEntry.getKey();
                if (actionType == ActionType.NONE || (actionData = actionEntry.getValue()) == null || !actionData.hasAction()) continue;
                listTag.add((Object)actionData.save(new CompoundTag()));
            }
            if (!listTag.isEmpty()) {
                compoundTag.m_128365_(DATA_ACTIONS_TAG, (Tag)listTag);
            }
        }
        return compoundTag;
    }

    public static Map<ActionType, ActionData> readActionData(CompoundTag compoundTag) {
        EnumMap<ActionType, ActionData> actions = new EnumMap<ActionType, ActionData>(ActionType.class);
        if (compoundTag.m_128441_(DATA_ACTIONS_TAG)) {
            ListTag listTag = compoundTag.m_128437_(DATA_ACTIONS_TAG, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                ActionData actionData = new ActionData(listTag.m_128728_(i));
                if (!actionData.hasActionType() || !actionData.hasAction()) continue;
                actions.put(actionData.getActionType(), actionData);
            }
        }
        return actions;
    }

    public static boolean hasActionData(CompoundTag compoundTag) {
        if (compoundTag.m_128441_(DATA_ACTIONS_TAG)) {
            ListTag listTag = compoundTag.m_128437_(DATA_ACTIONS_TAG, 10);
            return !listTag.isEmpty();
        }
        return false;
    }
}

