/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.network.NetworkMessage;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagePresetExport {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String name;

    public MessagePresetExport(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public static void handle(MessagePresetExport message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePresetExport.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePresetExport message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        Object name = message.getName();
        if (name == null || ((String)name).isEmpty()) {
            log.warn("Export preset name is empty for {}", (Object)uuid);
            return;
        }
        if (!((String)name).endsWith(".npc.nbt")) {
            name = (String)name + ".npc.nbt";
        }
        NetworkMessage.exportPresetClient(uuid, (String)name, serverPlayer);
    }
}

