/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.CustomPresetData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagePresetExportClient {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final String name;
    protected final String skinModel;
    protected final String fileName;
    protected final CompoundTag data;

    public MessagePresetExportClient(UUID uuid, String name, String skinModel, String fileName, CompoundTag data) {
        this.uuid = uuid;
        this.name = name;
        this.skinModel = skinModel;
        this.fileName = fileName;
        this.data = data;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getSkinModel() {
        return this.skinModel;
    }

    public String getFileName() {
        return this.fileName;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public static void handle(MessagePresetExportClient message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MessagePresetExportClient.handlePacket(message)));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePresetExportClient message) {
        UUID uuid = message.getUUID();
        if (uuid == null || uuid.toString().isEmpty()) {
            log.error("Invalid UUID {} for {}", (Object)uuid, (Object)message);
            return;
        }
        String name = message.getName();
        if (name == null || name.isEmpty()) {
            log.error("Invalid name {} for {}", (Object)name, (Object)message);
            return;
        }
        String skinModelName = message.getSkinModel();
        SkinModel skinModel = SkinModel.get(skinModelName);
        if (skinModelName == null || skinModelName.isEmpty() || skinModel == null) {
            log.error("Invalid skin model {} for {}", (Object)skinModel, (Object)message);
            return;
        }
        CompoundTag data = message.getData();
        if (data == null) {
            log.error("Invalid data {} for {}", (Object)data, (Object)message);
            return;
        }
        String fileName = message.getFileName();
        if (fileName == null || fileName.isEmpty()) {
            log.warn("Export preset file name is empty for {}", (Object)uuid);
            return;
        }
        File presetFile = CustomPresetData.getPresetFile(skinModel, fileName);
        log.info("Exporting EasyNPC {} with UUID {} and skin {} to {}", (Object)name, (Object)uuid, (Object)skinModel, (Object)presetFile);
        try {
            NbtIo.m_128944_((CompoundTag)data, (File)presetFile);
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC " + name + " with UUID " + uuid + " and skin " + skinModel + " to " + presetFile, (Throwable)exception);
        }
    }
}

