/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagePresetImport {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final CompoundTag compoundTag;

    public MessagePresetImport(UUID uuid, CompoundTag compoundTag) {
        this.uuid = uuid;
        this.compoundTag = compoundTag;
    }

    public CompoundTag getCompoundTag() {
        return this.compoundTag;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessagePresetImport message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessagePresetImport.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessagePresetImport message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        CompoundTag compoundTag = message.getCompoundTag();
        if (compoundTag == null) {
            log.error("Invalid compoundTag {} from {}", (Object)compoundTag, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (compoundTag.m_128441_("id") && !compoundTag.m_128461_("id").isEmpty() && !compoundTag.m_128461_("id").equals(easyNPCEntity.m_20078_())) {
            log.error("Invalid id {} for {} expected {} from {}", (Object)compoundTag.m_128461_("id"), (Object)easyNPCEntity, (Object)easyNPCEntity.m_20078_(), (Object)serverPlayer);
            return;
        }
        if (compoundTag.m_128441_("id") && compoundTag.m_128441_("pos")) {
            log.debug("Importing full preset {} for {} from {}", (Object)compoundTag, (Object)easyNPCEntity, (Object)serverPlayer);
        } else {
            log.debug("Merge preset {} for {} from {}", (Object)compoundTag, (Object)easyNPCEntity, (Object)serverPlayer);
        }
        easyNPCEntity.importPreset(compoundTag);
    }
}

