/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.EasyNPCEntity;
import de.markusbordihn.easynpc.entity.EntityManager;
import de.markusbordihn.easynpc.entity.Profession;
import de.markusbordihn.easynpc.network.message.MessageHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageProfessionChange {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final UUID uuid;
    protected final Profession profession;

    public MessageProfessionChange(UUID uuid, Profession profession) {
        this.uuid = uuid;
        this.profession = profession;
    }

    public Profession getProfession() {
        return this.profession;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static void handle(MessageProfessionChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageProfessionChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageProfessionChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !MessageHelper.checkAccess(uuid, serverPlayer)) {
            return;
        }
        Profession profession = message.getProfession();
        if (profession == null) {
            log.error("Invalid profession {} for {} from {}", (Object)profession, (Object)message, (Object)serverPlayer);
            return;
        }
        EasyNPCEntity easyNPCEntity = EntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        log.debug("Change profession {} for {} from {}", (Object)profession, (Object)easyNPCEntity, (Object)serverPlayer);
        easyNPCEntity.setProfession(profession);
    }
}

